//
//  AOILayerController.m
//  QMapKitDemo
//
//  Created by v_hefang on 2020/7/8.
//  Copyright © 2020 tencent. All rights reserved.
//

#import "AOILayerController.h"
#import <QMapKit/QMSSearchKit.h>

@interface AOILayerController () <QMSSearchDelegate>
@property (nonatomic, strong) QAOILayer *aoiLayer;
@property (nonatomic, strong) QMSSearcher *searcher;
@property (nonatomic, strong) NSString *poiId;
@end

@implementation AOILayerController


- (NSString *)testTitle {
	return @"删除";
}

- (void)handleTestAction {
	if (self.aoiLayer) {
		[self.mapView removeAOILayer:self.aoiLayer];
	}
}

- (void)viewDidLoad { [super viewDidLoad];
	self.mapView.centerCoordinate = CLLocationCoordinate2DMake(39.992870,116.310250);
	self.mapView.zoomLevel = 14;
	
	[self search];
}

- (void)search {
	[QMSSearchServices sharedServices].apiKey = @"请输入您的检索Key";
	
	_searcher = [[QMSSearcher alloc] initWithDelegate:self];
	
	QMSPoiSearchOption *poiSearchOption = [[QMSPoiSearchOption alloc] init];
	
	[poiSearchOption setKeyword:@"北京大学"];
	[poiSearchOption setBoundaryByRegionWithCityName:@"北京" autoExtend:NO];
	
	
	[_searcher searchWithPoiSearchOption:poiSearchOption];
}

- (void)searchWithPoiSearchOption:(QMSPoiSearchOption *)poiSearchOption didReceiveResult:(QMSPoiSearchResult *)poiSearchResult
{
	// 获取poi id
	QMSPoiData *poiData = [poiSearchResult.dataArray objectAtIndex:0];
	_poiId = poiData.id_;
	
	// 创建AOILayer
	[self createAOILayer];
}

- (void)createAOILayer {
	// 11107399966856067949
	self.aoiLayer = [[QAOILayer alloc] initWithUID:_poiId];
	self.aoiLayer.maxZoom = 18;
	self.aoiLayer.minZoom = 15;
	
	__weak typeof(self) weakSelf = self;
	[self.mapView addAOILayer:self.aoiLayer callback:^(BOOL success) {
		NSLog(@"success:%@", success? @"YES":@"NO");
		weakSelf.mapView.zoomLevel = 15;
	}];
}

@end
