//
//  OfflineMapViewController.m
//  QMapKitDebugging
//
//  Created by Keith Cao on 2020/5/13.
//  Copyright © 2020 tencent. All rights reserved.
//

#import "OfflineMapViewController.h"
#import "OfflineDownloadController.h"

@interface OfflineMapViewController ()
{
    // 统计回调次数
    int will, did;
}

@property (nonatomic, strong) NSMutableArray *items;

@end

@implementation OfflineMapViewController

- (void)setupNavigationBar
{   
    self.navigationController.navigationBar.translucent = NO;
    
    UIBarButtonItem *downloadItem = [[UIBarButtonItem alloc] initWithTitle:@"下载管理"
                                                                     style:UIBarButtonItemStylePlain
                                                                    target:self
                                                                    action:@selector(handleDownloadPage)];
    self.navigationItem.rightBarButtonItem = downloadItem;
}

- (void)handleDownloadPage {
    OfflineDownloadController *downloadController = [[OfflineDownloadController alloc] init];
    
    // 取出北京和广州的信息
    NSArray *items = [[QOfflineMap sharedOfflineMap] items];
    QOfflineItem *bjItem;
    QOfflineItem *gdItem;
    for (QOfflineItem *item in items) {
        if ([item.name isEqualToString:@"北京市"]) {
            bjItem = item;
        }
        
        if ([item.name isEqualToString:@"广东省"]) {
            gdItem = item;
        }
    }
    
    if (bjItem == nil || gdItem == nil) {
        return;
    }
    NSArray *citys = @[bjItem, gdItem];
    downloadController.cityArray = citys;
    
    [self.navigationController pushViewController:downloadController animated:YES];
}


- (QOfflineItem *)findItemByName:(NSString *)name {
    NSArray *cities = [QOfflineMap sharedOfflineMap].items;
    for (int i=0; i<cities.count; i++) {
        QOfflineItem *item = [cities objectAtIndex:i];
        if ([item.pinyin isEqualToString:name]) {
            return item;
        }
    }
    return nil;
}

- (void)handleEnable
{
    self.mapView.offlineMapEnable = YES;
}


- (void)handleTestAction
{
    self.mapView.offlineMapEnable = NO;
}

- (void)mapView:(QMapView *)mapView regionDidChangeAnimated:(BOOL)animated gesture:(BOOL)bGesture
{
    did++;
    NSLog(@"regionDidChangeAnimated. %d, %d. [%d]. zoom:%f. (%f,%f)", animated, bGesture, did, mapView.zoomLevel, mapView.centerCoordinate.latitude, mapView.centerCoordinate.longitude);
    
//    self.led.text = [NSString stringWithFormat:@"lv:%.2f", mapView.zoomLevel];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    self.items = [[NSMutableArray alloc] init];
    
    self.mapView.shows3DBuildings = YES;
    self.mapView.showsBuildings = YES;
    self.mapView.showsCompass = YES;

    self.mapView.offlineMapEnable = YES;
    
    NSLog(@"offlinemap status:%d", self.mapView.isOfflineMapEnable);
    [[QOfflineMap sharedOfflineMap] reloadItems:^(BOOL setUpSuccess) {
        NSLog(@"setup:%d", setUpSuccess);
    }];
    
    self.mapView.zoomLevel = 13;
    self.mapView.centerCoordinate = CLLocationCoordinate2DMake(39.918268, 116.392854);
    

}

@end
