//
//  TestViewController.m
//  QMapKitDemo
//
//  Created by tabsong on 2017/7/20.
//  Copyright © 2017年 tencent. All rights reserved.
//

#import "FixPositionAnnotationViewController.h"

@interface FixPositionAnnotationViewController ()

@property (nonatomic, strong) QPointAnnotation *annotation;

@end

@implementation FixPositionAnnotationViewController

- (QAnnotationView *)mapView:(QMapView *)mapView viewForAnnotation:(id<QAnnotation>)annotation
{
    if ([annotation isKindOfClass:[QPointAnnotation class]])
    {
        static NSString *pointReuseIndetifier = @"pointReuseIndetifier";
        QAnnotationView *annotationView = (QAnnotationView*)[self.mapView dequeueReusableAnnotationViewWithIdentifier:pointReuseIndetifier];
        
        if (annotationView == nil)
        {
            annotationView = [[QAnnotationView alloc] initWithAnnotation:annotation reuseIdentifier:pointReuseIndetifier];
        }
        
        UIImage *img = [UIImage imageNamed:@"marker"];
        
        annotationView.image = img;
        annotationView.centerOffset = CGPointMake(0, -img.size.height / 2.0);
        
        return annotationView;
    }
    
    return nil;
}

- (void)setUpLockScreenAnnotation
{
	
	self.annotation = [[QPointAnnotation alloc] init];
	
	CGPoint lockScreenPosition = CGPointMake(self.mapView.bounds.size.width / 2, self.mapView.bounds.size.height / 2);
	
	self.annotation.lockedToScreen = YES;
	self.annotation.lockedScreenPoint = lockScreenPosition;
	
	[self.mapView addAnnotation:self.annotation];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	[self setUpLockScreenAnnotation];
}

@end
