//
//  EntryData.m
//  QMapKitDemoNew
//
//  Created by tabsong on 17/5/11.
//  Copyright © 2017年 Tencent. All rights reserved.
//

#import "EntryData.h"
#import <QMapKit/QMapKit.h>

@implementation Cell

@end

@implementation Section

@end

@implementation EntryData

+ (instancetype)constructDefaultEntryData
{
    EntryData *entry = [[EntryData alloc] init];
    entry.title = [NSString stringWithFormat:@"3D Map Demos %@", QMapServices.sharedServices.sdkVersion];
    NSMutableArray<Section *> *sectionArray = [NSMutableArray array];
    entry.sections = sectionArray;
    
    // Map Section.
    {
        Section *section = [[Section alloc] init];
        section.title = @"底图";
        NSMutableArray<Cell *> *cellArray = [NSMutableArray array];
        section.cells = cellArray;
        
        [sectionArray addObject:section];
        
        // 基础底图Cell.
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"基础底图";
            cell.controllerClassName = @"MapViewController";
            
            [cellArray addObject:cell];
        }
        
        // 手势控制Cell.
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"手势控制";
            cell.controllerClassName = @"GestureControlViewController";
            
            [cellArray addObject:cell];
        }
    
        //个性化地图
        {
            Cell *cell = [[Cell alloc] init];
        
            cell.title = @"个性化地图";
            cell.controllerClassName = @"MultiStyleViewController";
        
            [cellArray addObject:cell];
        }
    
        //手绘图
        {
            Cell *cell = [[Cell alloc] init];
        
            cell.title = @"手绘图";
            cell.controllerClassName = @"HandDrawMapViewController";
        
            [cellArray addObject:cell];
        }
		
		//路况样式
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"自定义路况样式";
			cell.controllerClassName = @"TrafficStyleViewController";
			
			[cellArray addObject:cell];
		}
        
        // 底图状态CoreAnimation
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"底图 CoreAnimation";
            cell.controllerClassName = @"MapCoreAnimationViewController";

            
            [cellArray addObject:cell];
        }
    }
    
    // Annotation Section.
    {
        Section *section = [[Section alloc] init];
        section.title = @"标注";
        NSMutableArray<Cell *> *cellArray = [NSMutableArray array];
        section.cells = cellArray;
        
        [sectionArray addObject:section];
        
        // 基础标注Cell.
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"基础标注";
            cell.controllerClassName = @"AnnotationViewController";
            
            [cellArray addObject:cell];
        }
        
        // 大头针标注Cell.
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"大头针标注";
            cell.controllerClassName = @"PinAnnotationViewController";
            
            [cellArray addObject:cell];
        }
        
        // 自定义标注Cell.
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"自定义标注";
            cell.controllerClassName = @"CustomAnnotationViewController";
            
            [cellArray addObject:cell];
        }
        
        // 自定义callout Cell.
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"自定义Callout";
            cell.controllerClassName = @"CustomCalloutViewController";
            
            [cellArray addObject:cell];
        }
        
        // 标注平移动画Cell.
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"标注 Coordinate 动画";
            cell.controllerClassName = @"AnnotationAnimateCoordinateViewController";
            
            [cellArray addObject:cell];
        }
        
        // 标注普通动画Cell.
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"标注 CoreAnimation";
            cell.controllerClassName = @"AnnotationCoreAnimationViewController";
            
            [cellArray addObject:cell];
        }
        
        // 标注普通动画Cell.
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"固定屏幕标注";
            cell.controllerClassName = @"FixPositionAnnotationViewController";
            
            [cellArray addObject:cell];
        }
    
		// 标注碰撞.
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"标注碰撞";
			cell.controllerClassName = @"AnnotationViewCollisionController";
			
			[cellArray addObject:cell];
		}
		
		// 标注自定义碰撞主View.
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"标注自定义碰撞主View";
			cell.controllerClassName = @"AnnotationViewCustomCollisionMainViewController";
			
			[cellArray addObject:cell];
		}
		
        // 缩放地图展示标记Cell.
        {
        Cell *cell = [[Cell alloc] init];
        
        cell.title = @"缩放地图展示标注";
        cell.controllerClassName = @"ShowRelatedAnnotationViewController";
        
        [cellArray addObject:cell];
        }
    }
    
    //Control interaction
    {
        Section *section = [[Section alloc] init];
        section.title = @"交互";
        NSMutableArray<Cell *> *cellArray = [NSMutableArray array];
        section.cells = cellArray;
    
        [sectionArray addObject:section];
    
    //控件交互
        {
        
            Cell *cell = [[Cell alloc] init];
        
            cell.title = @"控件交互";
            cell.controllerClassName = @"ControlPanelInteractViewController";
        
            [cellArray addObject:cell];
        }
    
        //Change center location
        {
        
            Cell *cell = [[Cell alloc] init];
        
            cell.title = @"变更地图中心";
            cell.controllerClassName = @"ChangeMapCenterViewController";
        
            [cellArray addObject:cell];
        }
    
    
        //展示选定区域
        {
        
            Cell *cell = [[Cell alloc] init];
        
            cell.title = @"展示选定区域";
            cell.controllerClassName = @"DisplaySelectedRegionViewController";
        
            [cellArray addObject:cell];
        }
    
        //长按添加标记点
        {
        
            Cell *cell = [[Cell alloc] init];
        
            cell.title = @"自定义手势(长按添加标记点)";
            cell.controllerClassName = @"LongpressAnnotationViewController";
        
            [cellArray addObject:cell];
        }
    
    }
    
    //室内
    {
        Section *section = [[Section alloc] init];
        section.title = @"室内";
        NSMutableArray<Cell *> *cellArray = [NSMutableArray array];
        section.cells = cellArray;
    
        [sectionArray addObject:section];
    
            {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"室内图";
            cell.controllerClassName = @"IndoorViewController";
            
            [cellArray addObject:cell];
            }
    }
    
    // 限定区域
    {
        Section *section = [[Section alloc] init];
        section.title = @"限定区域";
        NSMutableArray<Cell *> *cellArray = [NSMutableArray array];
        section.cells = cellArray;
    
        [sectionArray addObject:section];
    
        {
            Cell *cell = [[Cell alloc] init];
        
            cell.title = @"限定区域";
            cell.controllerClassName = @"LimitMapRectViewController";
        
            [cellArray addObject:cell];
        }
    }
    
    // Overlay Section.
    {
        Section *section = [[Section alloc] init];
        section.title = @"Overlay";
        NSMutableArray<Cell *> *cellArray = [NSMutableArray array];
        section.cells = cellArray;
        
        [sectionArray addObject:section];
        
        // 基础Overlay
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"基础Polygon";
            cell.controllerClassName = @"ShowPolygonViewController";
            
            [cellArray addObject:cell];
        }
		
		// 虚线polygon
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"虚线描边polygon";
			cell.controllerClassName = @"DashPolygonViewController";
			
			[cellArray addObject:cell];
		}
		
		// 带洞polygon
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"带洞polygon";
			cell.controllerClassName = @"PolygonWithHoleViewController";
			
			[cellArray addObject:cell];
		}
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"Polyline";
			cell.controllerClassName = @"PolylineViewController";
			
			[cellArray addObject:cell];
		}
		
		// Route Overlay
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"蚯蚓线";
			cell.controllerClassName = @"TexturePolylineViewController";
			
			[cellArray addObject:cell];
		}
		
		// Route Name
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"动态路名";
			cell.controllerClassName = @"RouteNameViewController";
			
			[cellArray addObject:cell];
		}
    
		// 路线擦除
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"路线擦除置灰";
			cell.controllerClassName = @"EraseLineViewController";
			
			[cellArray addObject:cell];
		}
		
		// GradientLineViewController
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"渐变色线";
			cell.controllerClassName = @"GradientLineViewController";
			
			[cellArray addObject:cell];
		}
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"圆覆盖物";
			cell.controllerClassName = @"CircleOverlayViewController";
			
			[cellArray addObject:cell];
		}
        // 自定义Overlay
        {
            Cell *cell = [[Cell alloc] init];
        
            cell.title = @"瓦片图";
            cell.controllerClassName = @"TileOverlayViewController";
        
            [cellArray addObject:cell];
        }
    
        //本地瓦片
        {
            Cell *cell = [[Cell alloc] init];
        
            cell.title = @"本地自定义瓦片图";
            cell.controllerClassName = @"CustomTileOverlayViewController";
        
            [cellArray addObject:cell];
        }
        
        {
            Cell *cell = [[Cell alloc] init];
        
            cell.title = @"个性化图层";
            cell.controllerClassName = @"CustomLayerViewController";
        
            [cellArray addObject:cell];
        }
    
    
        // 热力图 Cell.
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"栅格热力图";
            cell.controllerClassName = @"HeatViewController";
            
            [cellArray addObject:cell];
        }
    
        // OpenGL绘制.
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"自定义OpenGL绘制";
            cell.controllerClassName = @"GLDrawViewController";
            
            [cellArray addObject:cell];
        }
    
        // AOI
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"AOILAYER";
            cell.controllerClassName = @"AOILayerController";
            
            [cellArray addObject:cell];
        }
        
        // GroundOverlay
        {
            
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"GroundOverlay";
            cell.controllerClassName = @"GroundOverlayViewController";
            
            [cellArray addObject:cell];
        }
        
        // ArcPolylineViewController
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"弧线";
            cell.controllerClassName = @"ArcPolylineViewController";
            
            [cellArray addObject:cell];
        }
    }
	
	// 可视化图层 Section.
	{
		Section *section = [[Section alloc] init];
		section.title = @"可视化图层";
		NSMutableArray<Cell *> *cellArray = [NSMutableArray array];
		section.cells = cellArray;
		
		[sectionArray addObject:section];
		
		// 定位Cell.
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"矢量热力图";
			cell.controllerClassName = @"Heat3DViewController";
			
			[cellArray addObject:cell];
		}
		
		// 蜂窝热力
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"蜂窝热力图";
			cell.controllerClassName = @"VectorHeatViewController";
			
			[cellArray addObject:cell];
		}
		
		// 轨迹图
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"轨迹图";
			cell.controllerClassName = @"MigratationLineViewController";
			
			[cellArray addObject:cell];
		}
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"三维模型";
			cell.controllerClassName = @"QGLModelOverlayViewController";
			
			[cellArray addObject:cell];
		}
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"三维模型平移动画";
			cell.controllerClassName = @"ModelTranslateAnimationViewController";
			
			[cellArray addObject:cell];
		}
	}
    
    // 定位 Section.
    {
        Section *section = [[Section alloc] init];
        section.title = @"定位";
        NSMutableArray<Cell *> *cellArray = [NSMutableArray array];
        section.cells = cellArray;
        
        [sectionArray addObject:section];
        
        // 定位Cell.
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"定位";
            cell.controllerClassName = @"UserLocationViewController";
            
            [cellArray addObject:cell];
        }
        
        // 自定义定位样式
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"自定义定位样式";
            cell.controllerClassName = @"CustomUserLocationViewController";
            
            [cellArray addObject:cell];
        }
    }
    
    // 检索 Section.
    {
        Section *section = [[Section alloc] init];
        section.title = @"检索";
        NSMutableArray<Cell *> *cellArray = [NSMutableArray array];
        section.cells = cellArray;
        
        [sectionArray addObject:section];
        
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"驾车";
			cell.controllerClassName = @"DrivingSearchViewController";
			
			[cellArray addObject:cell];
		}
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"货车";
			cell.controllerClassName = @"TruckSearchViewController";
			
			[cellArray addObject:cell];
		}
		
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"步行";
            cell.controllerClassName = @"WalkingSearchViewController";
            
            [cellArray addObject:cell];
        }
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"公交";
			cell.controllerClassName = @"BusingSearchViewController";
			
			[cellArray addObject:cell];
		}
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"骑行";
			cell.controllerClassName = @"BicyclingSearchViewController";
			
			[cellArray addObject:cell];
		}
		
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"POI检索";
			cell.controllerClassName = @"POISearchViewController";
			
			[cellArray addObject:cell];
		}
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"POI周边推荐检索";
			cell.controllerClassName = @"POIExploreSearchViewController";
			
			[cellArray addObject:cell];
		}
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"POI ID检索";
			cell.controllerClassName = @"POIDetailSearchViewController";
			
			[cellArray addObject:cell];
		}
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"关键字提示检索";
			cell.controllerClassName = @"POISuggestionSearchViewController";
			
			[cellArray addObject:cell];
		}
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"地址转坐标";
			cell.controllerClassName = @"InvertGeoViewController";
			
			[cellArray addObject:cell];
		}
		
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"坐标转地址";
			cell.controllerClassName = @"ReverseGeoViewController";
			
			[cellArray addObject:cell];
		}
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"行政区划检索";
			cell.controllerClassName = @"DistrictAreaSearchViewController";
			
			[cellArray addObject:cell];
		}
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"省市列表检索";
			cell.controllerClassName = @"DistrictListSearchViewController";
			
			[cellArray addObject:cell];
		}
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"子行政区检索";
			cell.controllerClassName = @"DistrictChildrenSearchViewController";
			
			[cellArray addObject:cell];
		}
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"距离矩阵";
			cell.controllerClassName = @"DistanceMatrixSearchViewController";
			
			[cellArray addObject:cell];
		}
    }
    
    // 截图.
    {
        Section *section = [[Section alloc] init];
        section.title = @"截图";
        NSMutableArray<Cell *> *cellArray = [NSMutableArray array];
        section.cells = cellArray;
    
        [sectionArray addObject:section];
    
        // 截图.
        {
            Cell *cell = [[Cell alloc] init];
        
            cell.title = @"异步截图";
            cell.controllerClassName = @"SnapshotViewController";
        
            [cellArray addObject:cell];
        }
    }
	
	{
		Section *section = [[Section alloc] init];
		section.title = @"工具库";
		NSMutableArray<Cell *> *cellArray = [NSMutableArray array];
		section.cells = cellArray;
		
		[sectionArray addObject:section];
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"小车平移";
			cell.controllerClassName = @"AnnotationTranslationViewController";
			
			[cellArray addObject:cell];
		}
		
		{
			Cell *cell = [[Cell alloc] init];
			
			cell.title = @"点聚合";
			cell.controllerClassName = @"ClusterAnnotationViewController";
			
			[cellArray addObject:cell];
		}
	}
    
    // 离线地图
    {
        Section *section = [[Section alloc] init];
        section.title = @"离线地图";
        NSMutableArray<Cell *> *cellArray = [NSMutableArray array];
        section.cells = cellArray;
        
        [sectionArray addObject:section];
        
        // 离线地图.
        {
            Cell *cell = [[Cell alloc] init];
            
            cell.title = @"离线地图";
            cell.controllerClassName = @"OfflineMapViewController";
            
            [cellArray addObject:cell];
        }
    }
    return entry;
}

@end
