//
//  AppDelegate.m
//  QMapKitDemo
//
//  Created by tabsong on 2017/7/12.
//  Copyright © 2017年 tencent. All rights reserved.
//

#import "AppDelegate.h"
#import "EntryViewController.h"
#import <QMapKit/QMapKit.h>
#import <QMapKit/QMSSearchKit.h>

@interface AppDelegate ()

@end

@implementation AppDelegate


- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    
    self.window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
    
    // Configure API Key.
    [QMapServices sharedServices].APIKey = @"您的key";
	// 检索 api Key
	[[QMSSearchServices sharedServices] setApiKey:@"您的key"];
    if ([QMapServices sharedServices].APIKey.length == 0)
    {
        NSLog(@"Please configure API key before using QMapKit.framework");
    }
    
    EntryViewController *entry = [[EntryViewController alloc] init];
    UINavigationController *navigationController = [[UINavigationController alloc] initWithRootViewController:entry];
    
    self.window.rootViewController = navigationController;
    
    self.window.backgroundColor = [UIColor whiteColor];
    [self.window makeKeyAndVisible];
    
	// 隐私合规示例
	[self setUpAlert];
	
    return YES;
}

- (void)setUpAlert
{
	NSMutableParagraphStyle *paragraphStyle = [[NSMutableParagraphStyle alloc] init];
	
	paragraphStyle.alignment = NSTextAlignmentLeft;
	
	NSMutableAttributedString *message = [[NSMutableAttributedString alloc] initWithString:@"\n授权前请仔细阅读腾讯位置服务隐私协议内容: https://lbs.qq.com/userAgreements/agreements/privacy" attributes:@{
		NSParagraphStyleAttributeName:paragraphStyle,
	}];
	
	UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"隐私合规示例" message:@"" preferredStyle:UIAlertControllerStyleAlert];
	
	[alert setValue:message forKey:@"attributedMessage"];
	
	UIAlertAction *conform = [UIAlertAction actionWithTitle:@"同意" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
		//更新用户授权腾讯地图SDK隐私协议状态.  since 4.5.6
		[[QMapServices sharedServices] setPrivacyAgreement:YES];
	}];
	
	UIAlertAction *cancel = [UIAlertAction actionWithTitle:@"不同意" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
		//更新用户授权腾讯地图SDK隐私协议状态. since 4.5.6
		[[QMapServices sharedServices] setPrivacyAgreement:NO];
	}];
	
	[alert addAction:conform];
	[alert addAction:cancel];
	
	[self.window.rootViewController presentViewController:alert animated:YES completion:nil];
}

- (void)applicationWillResignActive:(UIApplication *)application {
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and invalidate graphics rendering callbacks. Games should use this method to pause the game.
}


- (void)applicationDidEnterBackground:(UIApplication *)application {
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
}


- (void)applicationWillEnterForeground:(UIApplication *)application {
    // Called as part of the transition from the background to the active state; here you can undo many of the changes made on entering the background.
}


- (void)applicationDidBecomeActive:(UIApplication *)application {
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
}


- (void)applicationWillTerminate:(UIApplication *)application {
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
}


@end
