//
//  QScatterNodeProtocol.h
//  QMapKit
//
//  Created by KeithCao on 2021/8/16.
//  Copyright © 2021 tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>

/**
 *  @brief 协议类。用于提供生成贴图散点图时需要的数据
 */
@protocol QScatterNodeProtocol <NSObject>

@required

/**
 *  @brief  坐标.
 */
@property (nonatomic, readonly) CLLocationCoordinate2D coordinate;

/**
 *  @brief  类型.
 */
@property (nonatomic, readonly) int type;

@end

/**
 * @brief 散点图节点数据
 */
@interface QScatterNode : NSObject <QScatterNodeProtocol>

/**
 *  @brief  节点的坐标.
 */
@property (nonatomic, assign) CLLocationCoordinate2D coordinate;

/**
 *  @brief  节点的类型. 用于贴图散点的图片和点散点的颜色的映射关系
 */
@property (nonatomic, assign) int type;

@end

