//
//  QMapView+ModelLight.h
//  QMapKit
//
//  Created by tabsong on 2023/3/27.
//  Copyright © 2023 tencent. All rights reserved.
//

#import <QMapKit/QMapKit.h>
#import "QLight.h"

NS_ASSUME_NONNULL_BEGIN

/**
 *  @brief  配置光照.
 *  @important: 当前所有的光照只对 三维模型渲染(QModelOverlay)生效。对于地图本身以及其他可视化图层无效。
 */
@interface QMapView (Light)

/**
 * @brief  设置环境光
 * @important:
 *  1. 当前光照渲染只对 三维模型有效，对于地图本身以及其他可视化图层无效。
 *
 * @param ambientLight 环境光.
 */
- (void)setAmbientLight:(QAmbientLight *)ambientLight;

/**
 * @brief  添加普通光源.
 * @important:
 *  1. 当前光照渲染只对 三维模型有效，对于地图本身以及其他可视化图层无效。
 *  2. 当前只能添加一个普通光源，QSpotFollowCameraLight 或者 QDirectionalLight，后添加的光源生效。
 *
 * @param commonLight 普通光源.
 */
- (void)addCommonLight:(QCommonLight *)commonLight;

@end

NS_ASSUME_NONNULL_END
