//
//  QMapView+GeneralProtocol.h
//  QMapKit
//
//  Created by tabsong on 2023/3/27.
//  Copyright © 2023 tencent. All rights reserved.
//
#import <QMapKit/QMapKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface QMapView (GeneralProtocol)

/**
 *  @brief 通用协议函数调用统一入口.
 *  @param commandJson 命令Json字符串
 *  @param visualLayer 可视化图层
 *  @return 函数返回值.
 */
- (NSString *)executeCommand:(NSString *)commandJson withVisualLayer:(QVisualLayer *)visualLayer;

@end

NS_ASSUME_NONNULL_END
