//
//  QLight.h
//  QMapKit
//
//  Created by tabsong on 2023/3/27.
//  Copyright © 2023 tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <GLKit/GLKit.h>

NS_ASSUME_NONNULL_BEGIN

/**
 *  @brief  光源基础类.
 */
@interface QBaseLight : NSObject

/**
 *  @brief  光照颜色. 默认为 白色 [UIColor whiteColor]，设置nil，会被忽略.
 */
@property (nonatomic, copy) UIColor *lightColor;

/**
 *  @brief  光照强度. 范围是 >= 0，当设置 < 0时 会被裁切成0
 */
@property (nonatomic) CGFloat intensity;

@end

/**
 *  @brief  环境光，默认 lightColor 光照颜色为白色[UIColor whiteColor]，intensity强度为0.
 */
@interface QAmbientLight : QBaseLight

@end

/**
 *  @brief 可添加到地图上的光源.
 */
@interface QCommonLight : QBaseLight

@end

/**
 *  @brief 挂载在摄像机上的点光源（无衰减），默认 lightColor 光照颜色为白色[UIColor whiteColor]，intensity强度为2.5.
 */
@interface QSpotFollowCameraLight : QCommonLight

@end

/**
 *  @brief 平行光. 默认 lightColor 光照颜色为白色[UIColor whiteColor]，intensity强度为2.5.
 */
@interface QDirectionalLight : QCommonLight

/**
 *  @brief  平行光方向向量. 默认为 GLKVector3Make(1, 0, 0)
 *   当前地图坐标系：
 *       X + 轴 : 正东
 *       Y + 轴 : 正北
 *       Z + 轴 : 天空朝上
 */
@property (nonatomic) GLKVector3 direction;

@end

NS_ASSUME_NONNULL_END
