//
//  QIconScatterOverlay.h
//  QMapKit
//
//  Created by Keith Cao on 2021/4/29.
//  Copyright © 2021 tencent. All rights reserved.
//

#import <QMapKit/QGLOverlay.h>
#import <UIKit/UIKit.h>
#import "QScatterNodeProtocol.h"

NS_ASSUME_NONNULL_BEGIN

/**
 *  @brief 贴图散点overlay类型, 搭配QIconScatterOverlayView使用
 */
@interface QIconScatterOverlay : QGLOverlay

/**
 *  @brief  散点图数据: 原始的节点数据. 数组每个元素符合 QScatterNodeProtocol 协议
 *
 */
@property (nonatomic, copy) NSArray <id <QScatterNodeProtocol> > *nodes;

/**
 *  @brief  贴图图片数组, 与贴图散点数据中的类型搭配使用，添加后无法修改
 *          使用说明: 根据QScatterNode中的type值选择对应的贴图
 *
 */
@property (nonatomic, strong) NSArray<UIImage *> *icons;

/**
 *  @brief  贴图大小, 单位: point, 默认值{width, height} = (10, 10)
 *
 */
@property (nonatomic, assign) CGSize size;

/**
 *  @brief  是否绘制3D效果. 默认为NO
 *
 */
@property (nonatomic, assign) BOOL enable3D;

@end

NS_ASSUME_NONNULL_END
