//
//  QArcOverlay.h
//  QMapKit
//
//  Created by fan on 2020/12/17.
//  Copyright © 2020 tencent. All rights reserved.
//

#import <QMapKit/QGLOverlay.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @brief 曲线的样式
 */
@interface QArcStyle : NSObject

/**
 *  @brief  曲线的三端渐变颜色
 *			颜色个数少于一个时，设置无效;
 *			颜色个数一个时, 无渐变效果;
 *			颜色个数两个时, 起点颜色到终点颜色渐变;
 *			颜色个数三个时, 渐变顺序为起点-中间点-终点;
 *  		颜色个数大于三个时, 设置无效
 */
@property (nonatomic, copy) NSArray<UIColor *> *gradient;

/**
 *  @brief  线宽, 默认值 2。单位: 屏幕
 */
@property (nonatomic, assign) CGFloat width;

/**
 *  @brief  起点切线的角. 角度需在(0,90]区间内
 */
@property (nonatomic, assign) CGFloat degree;

@end

/**
 * @brief 单条曲线的数据
 */
@interface QArcData : NSObject

/**
 *  @brief  起点的坐标.
 */
@property (nonatomic, assign) CLLocationCoordinate2D startPoint;
/**
 *  @brief  终点的坐标.
 */
@property (nonatomic, assign) CLLocationCoordinate2D endPoint;
           
@end

/**
 * @brief 曲线的动画类
 */
@interface QArcOverlayAnimation : QAnimation

/**
 *  @brief  高亮颜色.
 */
@property (nonatomic, strong) UIColor *highlightColor;

/**
 *  @brief  高亮持续时间.
 */
@property (nonatomic, assign) CGFloat highlightDuration;

@end

/**
 *  @brief  曲线类Overlay
 *  		与QArcOverlayView搭配使用
 */
@interface QArcOverlay : QGLOverlay

/**
 *  @brief  曲线线数据集合
 */
@property (nonatomic, copy ) NSArray<QArcData *> *curves;

/**
 *  @brief  曲线的样式.
 */
@property (nonatomic, strong) QArcStyle *style;

/**
 * @brief 曲线的动画类
 */
@property (nonatomic, strong) QArcOverlayAnimation *animation;

/**
 *  @brief  是否开启3D效果. 默认关闭
 */
@property (nonatomic, assign) BOOL enable3D;

@end

NS_ASSUME_NONNULL_END
