//
//  QMapCustomLocation.h
//  QMapFoundationKit
//
//  Created by Keith Cao on 2024/4/10.
//  Copyright © 2024 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "QMapCustomLocationSource.h"

/// 自定义定位位置协议
@protocol QMapCustomLocationDelegate <NSObject>

@optional

/// @brief	位置判定定位来源获取回调
/// @return	QMapCustomLocationSource 自定义位置信息对象
- (QMapCustomLocationSource  * _Nullable )parseQMapCustomLocationSource;

@end

NS_ASSUME_NONNULL_BEGIN

/**
 *	@brief 自定义位置相关单例
 */
@interface QMapCustomLocation : NSObject

+ (QMapCustomLocation *)shareInstance;

/// QMapCustomLocationDelegate 代理
/// @note 必须在地图初始化前设置
@property (nonatomic, nullable, weak) id <QMapCustomLocationDelegate> delegate;

@end

NS_ASSUME_NONNULL_END
