//
//  MigratationLineViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2021/4/28.
//  Copyright © 2021 tencent. All rights reserved.
//

#import "MigratationLineViewController.h"
#import "StyleView.h"
#import <QMapVisualPlugin/QMapPluginKit.h>

#define GlobalNavAndStatusHight (self.navigationController.navigationBar.frame.size.height + [[UIApplication sharedApplication] statusBarFrame].size.height)

static const NSInteger GlobalStyleTitleArrayCount = 18;

static NSString *const GlobalStyleTitleArray[GlobalStyleTitleArrayCount] =
{
	@"展示层级和颜色",
	@"弧度",
	@"级别",
	@"透明度",
	@"可见性",
	@"3D",
	@"线宽度",
	@"数据",
	@"zIndex",
	@"动画时间",
	@"动画开关",
	@"高亮时间",
	@"暗色配色1",
	@"暗色配色2",
	@"暗色配色3",
	@"标准配色1",
	@"标准配色2",
	@"标准配色3"
};


@interface MigratationLineViewController ()

@property (nonatomic, strong) QArcOverlay *arcOverlay;

@property (nonatomic, strong) QArcOverlay *arcOverlay2;

@property (nonatomic, strong) NSMutableArray *datas;

@property (nonatomic, strong) StyleView *styleView;

@end

@implementation MigratationLineViewController

- (void)viewDidLoad
{
	[super viewDidLoad];
	
	self.mapView.zoomLevel = 4;
	
	self.mapView.overlooking = 40;
	
	[self setupNavigation];
	[self setupToolbar];
	
	[self setUpCurveOverlay];
}

- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay
{
	if ([overlay isKindOfClass:[QArcOverlay class]]) {
		QArcOverlayView *av = [[QArcOverlayView alloc] initWithOverlay:overlay];
		return av;
	}
	return nil;
}

#pragma mark - Action

- (void)handleSwitchAction
{
	UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"请选择需要切换的样式" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
	
	[alertController addAction:[UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil]];
	
	for (int i = 0; i < GlobalStyleTitleArrayCount; i++)
	{
		[alertController addAction:[UIAlertAction actionWithTitle:GlobalStyleTitleArray[i] style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
			[self handleChangeAction:i];
		}]];
	}
	
	[self presentViewController:alertController animated:YES completion:nil];
}

- (void)handleChangeAction:(NSInteger)actNum
{
	switch (actNum) {
		case 0:
			
			[self changeColorAndDisplayLevel];
			
			break;
		case 1:
			[self changeRadian];
			
			break;
			
		case 2:
			[self changeZoom];
			
			break;
		case 3:
			[self changeOpacity];
			break;
			
		case 4:
			[self changeVisible];
			break;
		case 5:
			[self change3D];
			break;
		case 6:
			[self changeWidth];
			break;
		case 7:
			[self changeData];
			break;
		case 8:
			[self changeZIndex];
			break;
		case 9:
			[self changeAnimationTime];
			break;
		case 10:
			[self enableAnimation];
			break;
		case 11:
			[self changeHighlightTime];
			break;
		case 12:
			[self changeDarkModeColorOne];
			break;
		case 13:
			[self changeDarkModeColorTwo];
			break;
		case 14:
			[self changeDarkModeColorThree];
			break;
		case 15:
			[self changeStandardColor];
			break;
		case 16:
			[self changeStandardColorTWo];
			break;
		case 17:
			[self changeStandardColorThree];
			break;
		default:
			break;
	}
}

// 颜色+展示层级
- (void)changeColorAndDisplayLevel
{
	NSArray<UIColor *> *colorDB = @[
		[UIColor purpleColor],
		[UIColor cyanColor],
		[UIColor orangeColor]
	];
	
	self.arcOverlay.style.gradient = colorDB;
	
	QArcOverlayView *av = (QArcOverlayView *) [self.mapView viewForOverlay:self.arcOverlay];
	
	av.displayLevel = QOverlayLevelAboveLabels;
	// 刷新样式需调用此接口，否则新样式不生效
	[self.arcOverlay setNeedsDisplay];
	
}

// 1 弧度
- (void)changeRadian
{
	int size = arc4random() % 80 + 10;
	
	self.arcOverlay.style.degree = size;
	// 刷新样式需调用此接口，否则新样式不生效
	[self.arcOverlay setNeedsDisplay];
	
}

// 2 type 和 最大最小
- (void)changeZoom
{
	[self.arcOverlay setMinZoomLevel:5 maxZoomLevel:17];
}

// 3 透明
- (void)changeOpacity
{
	self.arcOverlay.opacity = self.arcOverlay.opacity == 1 ? 0.5 : 1;
	
}

// 4 可见性
- (void)changeVisible
{
	self.arcOverlay.visible = !self.arcOverlay.visible;
}

//5 3d
- (void)change3D
{
	self.arcOverlay.enable3D = !self.arcOverlay.enable3D;
	// 刷新样式需调用此接口，否则新样式不生效
	[self.arcOverlay setNeedsDisplay];
}

// 6 宽度
- (void)changeWidth
{
	int size = arc4random() % 15 + 5;
	
	self.arcOverlay.style.width = size;
	// 刷新样式需调用此接口，否则新样式不生效
	[self.arcOverlay setNeedsDisplay];
}

// 7 换数据
- (void)changeData
{
	self.arcOverlay.curves = [self buildSmallData];
	// 刷新样式需调用此接口，否则新样式不生效
	[self.arcOverlay setNeedsDisplay];
}

// 8 zindex
- (void)changeZIndex
{
	QArcOverlayView *av = (QArcOverlayView *) [self.mapView viewForOverlay:self.arcOverlay];
	
	av.zIndex = 1000;
}

// 9 动画时间
- (void)changeAnimationTime
{
	self.arcOverlay.animation.highlightColor = [UIColor orangeColor];
	self.arcOverlay.animation.highlightDuration = 6;
	self.arcOverlay.animation.duration		= 10;
	// 刷新样式需调用此接口，否则新样式不生效
	[self.arcOverlay setNeedsDisplay];
}

// 10 动画开关
- (void)enableAnimation
{
	
	if (self.arcOverlay.animation == nil || self.arcOverlay.animation.duration == 0)
	{
		self.arcOverlay.animation.highlightDuration = 6;
		self.arcOverlay.animation.duration		= 10;
	}
	else
	{
		//	关闭动画可将animation设为nil或将动画时间设为0
		//		self.arcOverlay.animation = nil;
		self.arcOverlay.animation.duration = 0;
	}
	
	// 刷新样式需调用此接口，否则新样式不生效
	[self.arcOverlay setNeedsDisplay];
}

// 11 高亮时间
- (void)changeHighlightTime
{
	if(self.arcOverlay.animation.highlightDuration > 0)
	{
		self.arcOverlay.animation.highlightDuration = 0;
	}
	else
	{
		self.arcOverlay.animation.highlightDuration = 2;
	}
	// 刷新样式需调用此接口，否则新样式不生效
	[self.arcOverlay setNeedsDisplay];
}

// 12 暗色配色1
- (void)changeDarkModeColorOne
{
	self.mapView.mapType = QMapTypeDark;
	self.mapView.overlooking = 40;
	if (self.arcOverlay)
	{
		self.arcOverlay.style.gradient = @[
			[UIColor colorWithRed:0x00/255.0 green:0xFF / 255.0 blue: 0xAA /255.0 alpha:1.0],
			[UIColor colorWithRed:0x00/255.0 green:0xFF / 255.0 blue: 0x55 /255.0 alpha:1.0],
			[UIColor colorWithRed:0x00/255.0 green:0xFF / 255.0 blue: 0xAA /255.0 alpha:1.0]
		];
		
		QArcOverlayAnimation *ani = [[QArcOverlayAnimation alloc] init];
		ani.highlightColor = [UIColor colorWithRed:0x99/255.0 green:0xFF / 255.0 blue: 0xDD /255.0 alpha:1.0];
		ani.highlightDuration = 0.5;
		
		self.arcOverlay.enable3D = TRUE;
		
		self.arcOverlay.animation = ani;
		// 刷新样式需调用此接口，否则新样式不生效
		[self.arcOverlay setNeedsDisplay];
	}
	
}

// 13 暗色配色2
- (void)changeDarkModeColorTwo
{
	self.mapView.mapType = QMapTypeDark;
	self.mapView.overlooking = 40;
	if (self.arcOverlay)
	{
		self.arcOverlay.style.gradient = @[
			[UIColor colorWithRed:0xFF/255.0 green:0xD5 / 255.0 blue: 0x00 /255.0 alpha:1.0],
			[UIColor colorWithRed:0xFF/255.0 green:0x80 / 255.0 blue: 0x00 /255.0 alpha:1.0],
			[UIColor colorWithRed:0xFF/255.0 green:0xD5 / 255.0 blue: 0x00 /255.0 alpha:1.0]
		];
		
		QArcOverlayAnimation *ani = [[QArcOverlayAnimation alloc] init];
		ani.highlightColor = [UIColor colorWithRed:0xFF/255.0 green:0xEE / 255.0 blue: 0x99 /255.0 alpha:1.0];
		ani.highlightDuration = 0.5;
		self.arcOverlay.animation = ani;
		self.arcOverlay.enable3D = TRUE;
		// 刷新样式需调用此接口，否则新样式不生效
		[self.arcOverlay setNeedsDisplay];
	}
	
}

// 14 暗色配色3
- (void)changeDarkModeColorThree
{
	self.mapView.mapType = QMapTypeDark;
	self.mapView.overlooking = 40;
	
	if (self.arcOverlay)
	{
		self.arcOverlay.style.gradient = @[
			[UIColor colorWithRed:0x00/255.0 green:0xAA / 255.0 blue: 0xFF /255.0 alpha:1.0],
			[UIColor colorWithRed:0x00/255.0 green:0xFF / 255.0 blue: 0xFF /255.0 alpha:1.0],
			[UIColor colorWithRed:0x00/255.0 green:0xAA / 255.0 blue: 0xFF /255.0 alpha:1.0]
		];
		
		QArcOverlayAnimation *ani = [[QArcOverlayAnimation alloc] init];
		ani.highlightColor = [UIColor colorWithRed:0x99/255.0 green:0xDD / 255.0 blue: 0xFF /255.0 alpha:1.0];
		ani.highlightDuration = 0.5;
		self.arcOverlay.animation = ani;
		self.arcOverlay.enable3D = TRUE;
		// 刷新样式需调用此接口，否则新样式不生效
		[self.arcOverlay setNeedsDisplay];
	}
}

// 15 标准配色1
- (void)changeStandardColor
{
	self.mapView.mapType = QMapTypeStandard;
	self.mapView.overlooking = 40;
	if (self.arcOverlay)
	{
		self.arcOverlay.style.gradient = @[
			[UIColor colorWithRed:0x40/255.0 green:0xBF / 255.0 blue: 0x95 /255.0 alpha:1.0],
			[UIColor colorWithRed:0x40/255.0 green:0xBF / 255.0 blue: 0x6A /255.0 alpha:1.0],
			[UIColor colorWithRed:0x40/255.0 green:0xBF / 255.0 blue: 0x95 /255.0 alpha:1.0]
		];
		
		QArcOverlayAnimation *ani = [[QArcOverlayAnimation alloc] init];
		ani.highlightColor = [UIColor colorWithRed:0xB3/255.0 green:0xE5 / 255.0 blue: 0xD5 /255.0 alpha:1.0];
		ani.highlightDuration = 0.5;
		self.arcOverlay.enable3D = TRUE;
		self.arcOverlay.animation = ani;
		// 刷新样式需调用此接口，否则新样式不生效
		[self.arcOverlay setNeedsDisplay];
	}
}

// 16 标准配色2
- (void)changeStandardColorTWo
{
	self.mapView.mapType = QMapTypeStandard;
	self.mapView.overlooking = 40;
	if (self.arcOverlay)
	{
		self.arcOverlay.style.gradient = @[
			[UIColor colorWithRed:0xFF/255.0 green:0x80 / 255.0 blue: 0x00 /255.0 alpha:1.0],
			[UIColor colorWithRed:0xFF/255.0 green:0x2B / 255.0 blue: 0x00 /255.0 alpha:1.0],
			[UIColor colorWithRed:0xFF/255.0 green:0x80 / 255.0 blue: 0x00 /255.0 alpha:1.0]
		];
		
		QArcOverlayAnimation *ani = [[QArcOverlayAnimation alloc] init];
		ani.highlightColor = [UIColor colorWithRed:0xFF/255.0 green:0xCC / 255.0 blue: 0x99 /255.0 alpha:1.0];
		ani.highlightDuration = 0.5;
		self.arcOverlay.enable3D = TRUE;
		self.arcOverlay.animation = ani;
		// 刷新样式需调用此接口，否则新样式不生效
		[self.arcOverlay setNeedsDisplay];
	}
}

// 16 标准配色3
- (void)changeStandardColorThree
{
	self.mapView.mapType = QMapTypeStandard;
	self.mapView.overlooking = 40;
	if (self.arcOverlay)
	{
		self.arcOverlay.style.gradient = @[
			[UIColor colorWithRed:0x00/255.0 green:0x55 / 255.0 blue: 0xFF /255.0 alpha:1.0],
			[UIColor colorWithRed:0x00/255.0 green:0xAA / 255.0 blue: 0xFF /255.0 alpha:1.0],
			[UIColor colorWithRed:0x00/255.0 green:0x55 / 255.0 blue: 0xFF /255.0 alpha:1.0]
		];
		
		QArcOverlayAnimation *ani = [[QArcOverlayAnimation alloc] init];
		ani.highlightColor = [UIColor colorWithRed:0x66/255.0 green:0x99 / 255.0 blue: 0xFF /255.0 alpha:1.0];
		ani.highlightDuration = 0.5;
		self.arcOverlay.enable3D = TRUE;
		self.arcOverlay.animation = ani;
		// 刷新样式需调用此接口，否则新样式不生效
		[self.arcOverlay setNeedsDisplay];
	}
}

#pragma mark - Setup
- (void)viewWillAppear:(BOOL)animated
{
	[super viewWillAppear:animated];
	
	[self.navigationController setToolbarHidden:NO animated:animated];
}

- (void)viewWillDisappear:(BOOL)animated
{
	[super viewWillDisappear:animated];
	
	[self.navigationController setToolbarHidden:YES animated:animated];
}

- (void)setupToolbar
{
	UIBarButtonItem *flexble = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFlexibleSpace target:nil action:nil];
	
	UIBarButtonItem *add    = [[UIBarButtonItem alloc] initWithTitle:@"添加"  style:UIBarButtonItemStyleDone  target:self action:@selector(handleTestAction)];
	UIBarButtonItem *remove = [[UIBarButtonItem alloc] initWithTitle:@"删除"  style:UIBarButtonItemStyleDone  target:self action:@selector(handleRemoveAction)];
	UIBarButtonItem *reload = [[UIBarButtonItem alloc] initWithTitle:@"再加一个"  style:UIBarButtonItemStyleDone  target:self action:@selector(handleReloadAction)];
	
	self.toolbarItems = @[flexble, add, flexble, remove, flexble, reload, flexble, flexble];
}

- (void)setupNavigation
{
	self.navigationController.navigationBar.translucent = YES;
	
	UIBarButtonItem *switchButton = [[UIBarButtonItem alloc] initWithTitle:@"切换样式" style:UIBarButtonItemStyleDone target:self action:@selector(handleSwitchAction)];
	
	self.navigationItem.rightBarButtonItem = switchButton;
}

- (void)setupStyleView
{
	self.styleView = [[StyleView alloc] initWithFrame:CGRectMake(0, self.view.bounds.size.height - 100, self.view.bounds.size.width, 100)];
	self.styleView.autoresizingMask = UIViewAutoresizingFlexibleHeight | UIViewAutoresizingFlexibleWidth;
	
	[self.view addSubview:self.styleView];
}


- (void)handleTestAction
{
	[self setUpCurveOverlay];
}

- (void)handleRemoveAction
{
	[self.mapView removeOverlays:self.mapView.overlays];
}

- (void)handleReloadAction
{
	[self handleTest2Action];
}

- (void)handleTest2Action
{
	NSMutableArray<QArcData *> * curvDatas = [self buildSmallData];
	
	self.arcOverlay2 = [[QArcOverlay alloc] init];
	
	self.arcOverlay2.curves = curvDatas;
	
	QArcStyle *curstyle = [[QArcStyle alloc] init];
	
	curstyle.gradient = @[[UIColor blackColor], [UIColor yellowColor], [UIColor purpleColor]];
	
	curstyle.width = 14;
	
	self.arcOverlay2.style = curstyle;
	
	[self.mapView addOverlay:self.arcOverlay2];
	
}

- (void)setUpCurveOverlay
{
	NSMutableArray<QArcData *> *curvDatas = [[NSMutableArray alloc] init];
	
	NSString *filePath = [[NSBundle mainBundle] pathForResource:@"arc.dat" ofType:nil];
	
	NSString *fileContents = [NSString stringWithContentsOfFile:filePath encoding:NSUTF8StringEncoding error:nil];
	
	NSArray* allLinedStrings = [fileContents componentsSeparatedByCharactersInSet:[NSCharacterSet newlineCharacterSet]];
	
	[allLinedStrings enumerateObjectsUsingBlock:^(NSString *  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
		
		NSArray *ar = [obj componentsSeparatedByCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
		if (ar.count == 5)
		{
			// 纬度. start point
			double lat = [ar[0] doubleValue];
			// 经度.
			double lon = [ar[1] doubleValue];
			
			// end point
			double lat2 = [ar[2] doubleValue];
			// 经度.
			double lon2 = [ar[3] doubleValue];
			
			QArcData *data = [[QArcData alloc] init];
			
			data.startPoint = CLLocationCoordinate2DMake(lat, lon);
			data.endPoint 	= CLLocationCoordinate2DMake(lat2, lon2);
			
			[curvDatas addObject:data];
		}
	}];
	
	self.mapView.mapType = QMapTypeDark;
	
	
	self.arcOverlay = [[QArcOverlay alloc] init];
	
	self.arcOverlay.curves = curvDatas;
	
	// 默认曲线样式
	QArcStyle *curstyle = [[QArcStyle alloc] init];
	
	self.arcOverlay.enable3D = YES;
	
	QArcOverlayAnimation *ani = [[QArcOverlayAnimation alloc] init];
	
	
	self.arcOverlay.style = curstyle;
	self.arcOverlay.animation = ani;
	
	[self.mapView addOverlay:self.arcOverlay];
}

- (NSMutableArray<QArcData *> *)buildSmallData {
	NSMutableArray<QArcData *> *curvDatas = [[NSMutableArray alloc] init];
	
	NSString *filePath = [[NSBundle mainBundle] pathForResource:@"arc2.dat" ofType:nil];
	
	NSString *fileContents = [NSString stringWithContentsOfFile:filePath encoding:NSUTF8StringEncoding error:nil];
	
	NSArray* allLinedStrings = [fileContents componentsSeparatedByCharactersInSet:[NSCharacterSet newlineCharacterSet]];
	
	[allLinedStrings enumerateObjectsUsingBlock:^(NSString *  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
		
		NSArray *ar = [obj componentsSeparatedByCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
		if (ar.count == 5)
		{
			// 纬度. start point
			double lat = [ar[0] doubleValue];
			// 经度.
			double lon = [ar[1] doubleValue];
			
			// end point
			double lat2 = [ar[2] doubleValue];
			// 经度.
			double lon2 = [ar[3] doubleValue];
			
			
			QArcData *data = [[QArcData alloc] init];
			
			data.startPoint = CLLocationCoordinate2DMake(lat, lon);
			data.endPoint 	= CLLocationCoordinate2DMake(lat2, lon2);
			
			[curvDatas addObject:data];
		}
	}];
	return curvDatas;
}

@end
