//
//  UserLocationViewController.m
//  QMapKitDebugging
//
//  Created by tabsong on 17/6/8.
//  Copyright © 2017年 tencent. All rights reserved.
//

#import "UserLocationViewController.h"

@interface UserLocationViewController ()

@end

@implementation UserLocationViewController

#pragma mark - QMapViewDelegate

- (void)mapViewWillStartLocatingUser:(QMapView *)mapView
{
    NSLog(@"%s", __FUNCTION__);
}

- (void)mapViewDidStopLocatingUser:(QMapView *)mapView
{
    NSLog(@"%s", __FUNCTION__);
}

/**
 * @brief 用户位置更新后，会调用此函数
 * @param mapView 地图View
 * @param userLocation 新的用户位置
 * @param fromHeading 是否为heading 变化触发，如果为location变化触发,则为NO
 */
- (void)mapView:(QMapView *)mapView didUpdateUserLocation:(QUserLocation *)userLocation fromHeading:(BOOL)fromHeading
{
    NSLog(@"%s fromHeading = %d, location = %@, heading = %@", __FUNCTION__, fromHeading, userLocation.location, userLocation.heading);
}

/**
 * @brief  定位失败后，会调用此函数
 * @param mapView 地图View
 * @param error 错误号，参考CLError.h中定义的错误号
 */
- (void)mapView:(QMapView *)mapView didFailToLocateUserWithError:(NSError *)error
{
    NSLog(@"%s error = %@", __FUNCTION__, error);
}

/**
 * @brief 定位时的userTrackingMode 改变时delegate调用此函数
 *  @param mapView 地图View
 *  @param mode QMUserTrackingMode
 *  @param animated 是否有动画
 */
- (void)mapView:(QMapView *)mapView didChangeUserTrackingMode:(QUserTrackingMode)mode animated:(BOOL)animated
{
	NSLog(@"%s mode = %ld, animated = %d", __FUNCTION__, (long)mode, animated);
}

/**
 * @brief 定位权限更改时的delegate调用此方法
 *  @param mapView 地图View
 */
- (void)locationManagerDidChangeAuthorization:(QMapView *)mapView {
    if (@available(iOS 14.0, *)) {
        NSLog(@"定位权限状态：%d", mapView.authorizationStatus);
        NSLog(@"定位精度权限状态：%ld", (long)mapView.accuracyAuthorization);
    }
}

- (void)handleTestAction
{
    self.mapView.showsUserLocation = YES;
}

- (NSString *)testTitle
{
    return  @"打开定位";
}

#pragma mark - Life Cycle

- (void)viewDidLoad
{
    [super viewDidLoad];
}

@end
