//
//  DrivingSearchViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2023/10/18.
//  Copyright © 2023 tencent. All rights reserved.
//

#import "DrivingSearchViewController.h"
#import <QMapKit/QMSSearchKit.h>
#import "QSearchTools.h"
@interface DrivingSearchViewController () <QMSSearchDelegate>

@property (nonatomic, strong) QMSSearcher *searcher;

@end

@implementation DrivingSearchViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
	[self searchDrivingRoutePlan];
}


- (void)searchDrivingRoutePlan
{
	self.searcher = [[QMSSearcher alloc] initWithDelegate:self];
	
	QMSDrivingRouteSearchOption *drivingSearchOption = [[QMSDrivingRouteSearchOption alloc] init];
	[drivingSearchOption setFromCoordinate:CLLocationCoordinate2DMake(39.960521,116.318928)];
	[drivingSearchOption setToCoordinate:CLLocationCoordinate2DMake(39.866605,116.493904)];
	
	// 是否获取路况
	drivingSearchOption.get_speed = 1;
	
	// 查询偏好
	drivingSearchOption.perference = QMSDrivingRoutePerferenceRealTraffic;
	
	// 额外字段
	drivingSearchOption.added_fields = @"cities,toll_distance";
	
	drivingSearchOption.plate_number = @"京X309K3";
	// 是否获取多路线
	drivingSearchOption.get_mp = 1;
	
	// 发起检索
	[self.searcher searchWithDrivingRouteSearchOption:drivingSearchOption];
}

- (void)drawRouteLineWithResult:(QMSDrivingRouteSearchResult *)result
{
	[self.mapView removeOverlays:self.mapView.overlays];
	
	QMSRoutePlan *plan = result.routes.firstObject;
	
	// 创建线
	NSUInteger count = plan.polyline.count;
	CLLocationCoordinate2D coordinateArray[count];
	for (int i = 0; i < count; ++i)
	{
		coordinateArray[i] = [QSearchTools decodeCoordinateValue:[plan.polyline objectAtIndex:i]];
	}
	QPolyline *polyline = [[QPolyline alloc] initWithCoordinates:coordinateArray count:count];
	
	// 根据路况信息创建路线分段颜色
	NSArray *routeStyle = [QSearchTools getSegmentColorsFromRouteCondition:plan.speed];
	polyline.userData = routeStyle;
	
	[self.mapView addOverlay:polyline];
	
	// 调整视野
	[self.mapView setVisibleMapRect:polyline.boundingMapRect edgePadding:UIEdgeInsetsMake(50, 30, 30, 50) animated:YES];
}

#pragma mark -- MapDelegate
- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay
{
	if ([overlay isKindOfClass:[QPolyline class]])
	{
		QPolyline *polyline = (QPolyline*)overlay;
		QTexturePolylineView *polylineRender = [[QTexturePolylineView alloc] initWithPolyline:polyline];
		polylineRender.drawType = QTextureLineDrawType_ColorLine;
		// 分段颜色赋值
		polylineRender.segmentColor = polyline.userData;
		polylineRender.lineWidth = 8;
		return polylineRender;
	}
	return nil;
}

#pragma mark -- SearchDelegate

- (void)searchWithSearchOption:(QMSSearchOption *)searchOption didFailWithError:(NSError *)error
{
	NSLog(@"error:%@", error);
}

- (void)searchWithDrivingRouteSearchOption:(QMSDrivingRouteSearchOption *)drivingRouteSearchOption didRecevieResult:(QMSDrivingRouteSearchResult *)drivingRouteSearchResult
{
	[self drawRouteLineWithResult:drivingRouteSearchResult];
}

@end
