//
//  POIDetailSearchViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2023/10/19.
//  Copyright © 2023 tencent. All rights reserved.
//

#import "POIDetailSearchViewController.h"
#import <QMapKit/QMSSearchKit.h>
#import "QPoiAnnotation.h"

@interface POIDetailSearchViewController () <QMSSearchDelegate>

@property (nonatomic, strong) QMSSearcher *mySearcher;

@property (nonatomic, strong) QPoiAnnotation *anno;

@end

@implementation POIDetailSearchViewController

- (void)viewDidLoad {
	[super viewDidLoad];
	// Do any additional setup after loading the view.
	[self executePOIDetailSearch];
	self.mapView.delegate = self;
}

- (void)executePOIDetailSearch
{
	self.mySearcher = [[QMSSearcher alloc] initWithDelegate:self];
	
#if QMapKitVersion >= 50203
	QMSPoiDetailSearchOption *detailOpt = [[QMSPoiDetailSearchOption alloc] init];
	detailOpt.ID = @"6621879543162709731";
	[self.mySearcher searchWithPoiDetailSearchOption:detailOpt];
#endif
	
}

- (void)dealWithPoiSearchResult:(QMSPoiSearchResult *)result
{
	// 选择其中一个poi数据进行展示
	QMSPoiData *poiData = result.dataArray.firstObject;
	
	if (poiData)
	{
		self.anno = [[QPoiAnnotation alloc] initWithPoiData:poiData];
		self.anno.coordinate = poiData.location;
		self.anno.title = poiData.title;
		self.anno.subtitle = poiData.category;
		
		[self.mapView addAnnotation:self.anno];
		
		[self.mapView setCenterCoordinate:poiData.location animated:YES];
	}
}

#pragma mark -- SearchDelegate

- (void)searchWithSearchOption:(QMSSearchOption *)searchOption didFailWithError:(NSError *)error
{
	NSLog(@"error:%@", error);
}

#if QMapKitVersion >= 50203
- (void)searchWithPoiDetailSearchOption:(QMSPoiDetailSearchOption *)poiDetailSearchOption didReceiveResult:(QMSPoiSearchResult *)poiSearchResult
{
	[self dealWithPoiSearchResult:poiSearchResult];
}
#endif

#pragma mark -- MapView Delegate
- (QAnnotationView *)mapView:(QMapView *)mapView viewForAnnotation:(id<QAnnotation>)annotation
{
	if ([annotation isKindOfClass:[QPointAnnotation class]])
	{
		static NSString *pointReuseIndetifier = @"pointReuseIndetifier";
		QPinAnnotationView *annotationView = (QPinAnnotationView*)[self.mapView dequeueReusableAnnotationViewWithIdentifier:pointReuseIndetifier];
		
		if (annotationView == nil)
		{
			annotationView = [[QPinAnnotationView alloc] initWithAnnotation:annotation reuseIdentifier:pointReuseIndetifier];
		}
		
		// 可拖拽.
		//		annotationView.draggable = YES;
		
		annotationView.canShowCallout = YES;
		
		// 开启下落动画
		annotationView.animatesDrop = YES;
		
		return annotationView;
	}
	
	return nil;
}

- (void)mapView:(QMapView *)mapView regionDidChangeAnimated:(BOOL)animated gesture:(BOOL)bGesture
{
	if (self.anno)
	{
		QPinAnnotationView *pinAnnoView = (QPinAnnotationView *)[self.mapView viewForAnnotation:self.anno];
		if (pinAnnoView && !pinAnnoView.selected)
		{
			[self.mapView setSelectedAnnotations:@[self.anno]];
		}
	}
}

@end
