//
//  OfflineDownloadController.m
//  QMapKitDemo
//
//  Created by v_hefang on 2020/5/29.
//  Copyright © 2020 tencent. All rights reserved.
//

#import "OfflineDownloadController.h"
#import "OfflineDownloadCell.h"
#import <QMapKit/QMapKit.h>

@interface OfflineDownloadController () <UITableViewDataSource, UITableViewDelegate, OfflineDownloadCellDelegate>
@property (nonatomic, strong) UITableView *tableView;
@end

@implementation OfflineDownloadController

- (NSString *)title {
    return @"下载管理";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupTableView];
}

// 取消所有下载
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    
    for (QOfflineItem *item in [QOfflineMap sharedOfflineMap].downloadingItems) {
        [[QOfflineMap sharedOfflineMap] cancelDownload:item];
    }
}

- (void)setupTableView {
    _tableView = [[UITableView alloc] initWithFrame:CGRectMake(0, 0, self.view.bounds.size.width, self.view.bounds.size.height - self.navigationController.navigationBar.frame.size.height)
                                              style:UITableViewStyleGrouped];
    _tableView.dataSource = self;
    _tableView.delegate = self;
    [self.view addSubview:_tableView];
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return self.cityArray.count;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    NSUInteger rows = 0;
    
    if ([self.cityArray[section] isKindOfClass:[QOfflineProvince class]]) {
        QOfflineProvince *province = self.cityArray[section];
        rows = province.items.count;
    } else {
        rows = 1;
    }
    
    return rows;
}

- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section {
    QOfflineItem *item = self.cityArray[section];
    return item.name;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *reuseId = @"TableViewCell";
    OfflineDownloadCell *cell = [tableView dequeueReusableCellWithIdentifier:reuseId];
    if (cell == nil) {
        cell = [[OfflineDownloadCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:reuseId];
        cell.delegate = self;
    }
    
    
    if ([self.cityArray[indexPath.section] isKindOfClass:[QOfflineProvince class]]) {
        QOfflineProvince *province = self.cityArray[indexPath.section];
        cell.item = province.items[indexPath.row];
    } else {
        QOfflineItem *province = self.cityArray[indexPath.section];
        cell.item = province;
    }
    
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
}

- (void)offlineDownloadCell:(OfflineDownloadCell *)cell downloadWithItem:(QOfflineItem *)item {
    [[QOfflineMap sharedOfflineMap] downloadItem:item callback:^(QOfflineItem * _Nonnull downloadItem, QOfflineItemDownloadStatus status, id  _Nonnull info) {
        [self.tableView reloadData];
    }];
}

- (void)offlineDownloadCell:(OfflineDownloadCell *)cell cancelDownloadWithItem:(QOfflineItem *)item {
    [[QOfflineMap sharedOfflineMap] cancelDownload:item];
    [self.tableView reloadData];
}

- (void)offlineDownloadCell:(OfflineDownloadCell *)cell deleteWithItem:(QOfflineItem *)item {
    if (item.status != QOfflineItemStatusNone) {
        UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"删除" message:@"是否要删除该离线地图?" preferredStyle:UIAlertControllerStyleAlert];
        UIAlertAction *confirm = [UIAlertAction actionWithTitle:@"删除" style:UIAlertActionStyleDestructive handler:^(UIAlertAction * _Nonnull action) {
            [[QOfflineMap sharedOfflineMap] deleteItem:item];
            [alertController dismissViewControllerAnimated:YES completion:nil];
            [self.tableView reloadData];
        }];
        UIAlertAction *cancel = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
            [alertController dismissViewControllerAnimated:YES completion:nil];
        }];
        
        [alertController addAction:confirm];
        [alertController addAction:cancel];
        
        [self presentViewController:alertController animated:YES completion:nil];
    }
}

@end
