//
//  BaseMapViewController.m
//  QMapKitDebugging
//
//  Created by tabsong on 17/5/15.
//  Copyright © 2017年 tencent. All rights reserved.
//

#import "BaseMapViewController.h"

@interface BaseMapViewController ()<QMapViewDelegate>

@end

@implementation BaseMapViewController

- (void)handleTestAction
{
    
}

- (NSString *)testTitle
{
    return @"";
}

#pragma mark - Setup

- (void)setupNavigationBar
{
    self.navigationController.navigationBar.translucent = NO;
    
    UIBarButtonItem *testItem = [[UIBarButtonItem alloc] initWithTitle:[self testTitle]
                                                                 style:UIBarButtonItemStylePlain
                                                                target:self
                                                                action:@selector(handleTestAction)];
    self.navigationItem.rightBarButtonItem = testItem;
}

- (void)setupMapView
{
    self.mapView = [[QMapView alloc]
                    initWithFrame: CGRectMake(0,
                                              0,
                                              CGRectGetWidth(self.view.frame),
                                              CGRectGetHeight(self.view.frame) - CGRectGetMaxY(self.navigationController.navigationBar.frame))];
    self.mapView.delegate = self;
    
    self.mapView.centerCoordinate = CLLocationCoordinate2DMake(39.901268, 116.403854);
    self.mapView.zoomLevel        = 11;
    
    [self.view addSubview:self.mapView];
}

#pragma mark - Life Cycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [self setupNavigationBar];
    
    [self setupMapView];
    
    if (@available(iOS 12.0, *)) {
        if (self.traitCollection.userInterfaceStyle == UIUserInterfaceStyleDark)
        {
            self.mapView.mapType = QMapTypeDark;
        }
        else
        {
            self.mapView.mapType = QMapTypeStandard;
        }
    } else {
        // Fallback on earlier versions
    }
}

- (void)traitCollectionDidChange:(nullable UITraitCollection *)previousTraitCollection
{
    [super traitCollectionDidChange:previousTraitCollection];

    if (@available(iOS 12.0, *)) {
        if (self.traitCollection.userInterfaceStyle == UIUserInterfaceStyleDark)
        {
            self.mapView.mapType = QMapTypeDark;
        }
        else
        {
            self.mapView.mapType = QMapTypeStandard;
        }
    } else {
        // Fallback on earlier versions
    }
}

- (void)mapView:(QMapView *)mapView regionDidChangeAnimated:(BOOL)animated gesture:(BOOL)bGesture
{
	NSLog(@"regionDidChangeAnimated. %d, %d. zoom:%f. (%f,%f)", animated, bGesture, mapView.zoomLevel, mapView.centerCoordinate.latitude, mapView.centerCoordinate.longitude);

}

@end
