//
//  ReverseGeoViewController.m
//  QMapKitDebugging
//
//  Created by Keith Cao on 2019/8/5.
//  Copyright © 2019 tencent. All rights reserved.
//

#import "ReverseGeoViewController.h"
#import <QMapKit/QMSSearchKit.h>
#import "QPoiAnnotation.h"

@interface ReverseGeoViewController ()<QMSSearchDelegate, UIGestureRecognizerDelegate>

@property (nonatomic, strong) QMSSearcher *mySearcher;

@property (nonatomic, strong) QMSReverseGeoCodeSearchResult *revResult;

@property (nonatomic, assign) CLLocationCoordinate2D longPressedCoordinate;

@end

@implementation ReverseGeoViewController

- (NSString *)testTitle
{
    return @"清除marker";
}

- (void)handleTestAction
{
    [self.mapView removeAnnotations:self.mapView.annotations];
}

// 获取长按地理坐标
- (void)longPressAddMarker: (UIGestureRecognizer *) recognizer
{
    NSLog(@"longpressed");
    if (recognizer.state == UIGestureRecognizerStateBegan){
        CGPoint point = [recognizer locationOfTouch:0 inView:self.mapView];
        
        //转换坐标
        CLLocationCoordinate2D coordinateTapped = [self.mapView convertPoint:point toCoordinateFromView:self.mapView];
        
        [self reverseGeoSearch:coordinateTapped];
        
    }
}

// 根据长按得到的地理坐标进行逆地址搜索
-(void)reverseGeoSearch: (CLLocationCoordinate2D) coordinate
{
    self.longPressedCoordinate = coordinate;
    
    QMSReverseGeoCodeSearchOption *revGeoOption = [[QMSReverseGeoCodeSearchOption alloc] init];
    
    [revGeoOption setLocationWithCenterCoordinate:coordinate];
    
    [revGeoOption setGet_poi:YES];
    
    [self.mySearcher searchWithReverseGeoCodeSearchOption:revGeoOption];
}

- (void)setupAnnotation
{
	QPoiAnnotation *annotation = [[QPoiAnnotation alloc] initWithPoiData:self.revResult];
    [annotation setTitle:self.revResult.address];
    [annotation setCoordinate:self.longPressedCoordinate];
    
    [self.mapView addAnnotation:annotation];
}

- (QAnnotationView *)mapView:(QMapView *)mapView viewForAnnotation:(id<QAnnotation>)annotation
{
	if ([annotation isKindOfClass:[QPointAnnotation class]])
	{
		static NSString *pointReuseIndetifier = @"pointReuseIndetifier";
		QPinAnnotationView *annotationView = (QPinAnnotationView*)[self.mapView dequeueReusableAnnotationViewWithIdentifier:pointReuseIndetifier];
		
		if (annotationView == nil)
		{
			annotationView = [[QPinAnnotationView alloc] initWithAnnotation:annotation reuseIdentifier:pointReuseIndetifier];
		}
		
		// 可拖拽.
		//		annotationView.draggable = YES;
		
		annotationView.canShowCallout = YES;
		
		// 开启下落动画
		annotationView.animatesDrop = YES;
		
		return annotationView;
	}
	
	return nil;
}

#pragma mark - ReverseGeoSearchDelegate

- (void)searchWithSearchOption:(QMSSearchOption *)searchOption didFailWithError:(NSError *)error
{
    NSLog(@"error: %@",error);
}

- (void)searchWithReverseGeoCodeSearchOption:(QMSReverseGeoCodeSearchOption *)reverseGeoCodeSearchOption didReceiveResult:(QMSReverseGeoCodeSearchResult *)reverseGeoCodeSearchResult
{
    self.revResult = reverseGeoCodeSearchResult;
    NSLog(@"get result");
    [self setupAnnotation];
    
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    UILongPressGestureRecognizer *gestureRecognizer = [[UILongPressGestureRecognizer alloc]
                                                 initWithTarget:self
                                                       action:@selector(longPressAddMarker:)];
    [gestureRecognizer setDelegate:self];
    
    [self.mapView addGestureRecognizer:gestureRecognizer];
    
	[self setUpUI];
    self.mySearcher = [[QMSSearcher alloc] initWithDelegate:self];
            
}


- (void)setUpUI
{
	UIView *viewForLabel = [[UIView alloc] initWithFrame:CGRectMake(self.mapView.frame.origin.x, self.mapView.frame.origin.y, self.mapView.frame.size.width, 50)];
	viewForLabel.backgroundColor = [UIColor whiteColor];
	UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(viewForLabel.frame.size.width / 3, viewForLabel.frame.origin.y, 200, viewForLabel.frame.size.height)];
	
	label.text = @"长按添加Annotation";
	[viewForLabel addSubview:label];
	[self.mapView addSubview:viewForLabel];
}

@end
