//
//  POISearchViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2023/10/19.
//  Copyright © 2023 tencent. All rights reserved.
//

#import "POISearchViewController.h"
#import <QMapKit/QMSSearchKit.h>
#import "QPoiAnnotation.h"

@interface POISearchViewController () <QMSSearchDelegate>

@property (nonatomic, strong) QMSSearcher *mySearcher;

@property (nonatomic, strong) QPoiAnnotation *anno;

@end

@implementation POISearchViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
	[self executePOISearch];
	self.mapView.delegate = self;
}

- (void)executePOISearch
{
	self.mySearcher = [[QMSSearcher alloc] initWithDelegate:self];
	
	QMSPoiSearchOption *poiSearchOption = [[QMSPoiSearchOption alloc] init];
	[poiSearchOption setKeyword:@"学校"];
	[poiSearchOption setBoundaryByRegionWithCityName:@"北京" autoExtend:NO];
	poiSearchOption.page_index = 2;
	[poiSearchOption setFilterByCategories:@[@"大学",@"中学"]];
	poiSearchOption.get_subpois = @(1);		/// 是否返回子地点
	poiSearchOption.sub_title_format = @(1); /// 子点名称格式
	[self.mySearcher searchWithPoiSearchOption:poiSearchOption];
}

- (void)dealWithPoiSearchResult:(QMSPoiSearchResult *)result
{
	// 选择其中一个poi数据进行展示
	QMSPoiData *poiData = result.dataArray.firstObject;
	
	if (poiData)
	{
		self.anno = [[QPoiAnnotation alloc] initWithPoiData:poiData];
		self.anno.coordinate = poiData.location;
		self.anno.title = poiData.title;
		self.anno.subtitle = poiData.category;
		
		[self.mapView addAnnotation:self.anno];
		
		[self.mapView setCenterCoordinate:poiData.location animated:YES];
	}
}

#pragma mark -- SearchDelegate

- (void)searchWithSearchOption:(QMSSearchOption *)searchOption didFailWithError:(NSError *)error
{
	NSLog(@"error:%@", error);
}

- (void)searchWithPoiSearchOption:(QMSPoiSearchOption *)poiSearchOption didReceiveResult:(QMSPoiSearchResult *)poiSearchResult
{
	[self dealWithPoiSearchResult:poiSearchResult];
}

#pragma mark -- MapView Delegate
- (QAnnotationView *)mapView:(QMapView *)mapView viewForAnnotation:(id<QAnnotation>)annotation
{
	if ([annotation isKindOfClass:[QPointAnnotation class]])
	{
		static NSString *pointReuseIndetifier = @"pointReuseIndetifier";
		QPinAnnotationView *annotationView = (QPinAnnotationView*)[self.mapView dequeueReusableAnnotationViewWithIdentifier:pointReuseIndetifier];
		
		if (annotationView == nil)
		{
			annotationView = [[QPinAnnotationView alloc] initWithAnnotation:annotation reuseIdentifier:pointReuseIndetifier];
		}
		
		// 可拖拽.
//		annotationView.draggable = YES;
		
		annotationView.canShowCallout = YES;
		
		// 开启下落动画
		annotationView.animatesDrop = YES;
		
		return annotationView;
	}
	
	return nil;
}

- (void)mapView:(QMapView *)mapView regionDidChangeAnimated:(BOOL)animated gesture:(BOOL)bGesture
{
	if (self.anno)
	{
		QPinAnnotationView *pinAnnoView = (QPinAnnotationView *)[self.mapView viewForAnnotation:self.anno];
		if (pinAnnoView && !pinAnnoView.selected)
		{
			[self.mapView setSelectedAnnotations:@[self.anno]];
		}
	}
}

@end
