//
//  AnnotationViewCollisionController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2024/4/3.
//  Copyright © 2024 tencent. All rights reserved.
//

#import "AnnotationViewCollisionController.h"

/// QAnnotationView碰撞子View，遵循QAnnotationViewCollisionDelegate
@interface QCollisionChildView : UIView <QAnnotationViewCollisionDelegate>

@property (nonatomic, assign) QAnnotationViewCollisionType collisionType;

@end

@implementation QCollisionChildView


@end

@interface AnnotationViewCollisionController ()

@property (nonatomic, strong) QPointAnnotation *anno;

@property (nonatomic, strong) QPointAnnotation *anno2;

@end

@implementation AnnotationViewCollisionController

- (QAnnotationView *)mapView:(QMapView *)mapView viewForAnnotation:(id<QAnnotation>)annotation
{
	if ([annotation isKindOfClass:[QPointAnnotation class]])
	{
		static NSString *pointReuseIndetifier = @"pointReuseIndetifier";
		QAnnotationView *annotationView = (QAnnotationView*)[self.mapView dequeueReusableAnnotationViewWithIdentifier:pointReuseIndetifier];
		
		if (annotationView == nil)
		{
			annotationView = [[QAnnotationView alloc] initWithAnnotation:annotation reuseIdentifier:pointReuseIndetifier];
		}
		
		annotationView.canShowCallout   = YES;
		
		UIImage *img = [UIImage imageNamed:@"marker"];
		
		annotationView.image = img;
		annotationView.centerOffset = CGPointMake(0, -img.size.height / 2.0);
		annotationView.zIndex = [annotation.title intValue];
		annotationView.collisionType = QAnnotationViewCollisionWithLabel | QAnnotationViewCollisionWithQAnnotationView;
		
		[self addCollisionChild:annotationView];
		
		return annotationView;
	}
	
	return nil;
}


#pragma mark - Setup

- (void)setupAnnotations
{	
	{
		self.anno = [[QPointAnnotation alloc] init];
		self.anno.coordinate = CLLocationCoordinate2DMake(39.8791, 116.3672);
		self.anno.title = @"100";
		
		[self.mapView addAnnotation:self.anno];
	}
	
	{
		self.anno2 = [[QPointAnnotation alloc] init];
		self.anno2.coordinate = CLLocationCoordinate2DMake(39.884318,116.461515);
		self.anno2.title = @"10";
		[self.mapView addAnnotation:self.anno2];
	}
}

- (void)viewDidLoad
{
	[super viewDidLoad];
	
	[self setupAnnotations];
}

#pragma mark -- Colllision

- (void)addCollisionChild:(QAnnotationView *)annoView
{
	QCollisionChildView *childView = [[QCollisionChildView alloc] init];
	// 设置碰撞类型
	childView.collisionType = QAnnotationViewCollisionWithLabel | QAnnotationViewCollisionWithQAnnotationView;
	UIImage *image = [UIImage imageNamed:@"good"];
	UIImageView *imagaView = [[UIImageView alloc] initWithImage:image];
	childView.frame = CGRectMake(0, annoView.frame.size.height, image.size.width, image.size.height);
	[childView addSubview:imagaView];
	
	// 先添加到View Hierarchy
	[annoView addSubview:childView];
	[annoView addQAnnotationViewCollisionChild:childView];
}

@end
