//
//  QTrailOverlay.h
//  QMapKit
//
//  Created by Keith Cao on 2021/7/7.
//  Copyright © 2021 tencent. All rights reserved.
//

#import <QMapKit/QGLOverlay.h>

NS_ASSUME_NONNULL_BEGIN

/**
 *  @brief  轨迹线的类型
 */
typedef enum
{
	QTrailLineNormal = 0,   ///轨迹线
}QTrailType;

/**
 *  @brief  轨迹线样式
 */
@interface QTrailLineStyle : NSObject

/**
 *  @brief  轨迹类型
 */
@property (nonatomic, assign) QTrailType lineType;

/**
 *  @brief  轨迹线的颜色数组, 数组长度需大于0, 且最大长度为3.
 *          用法说明: 实现单色线, 则colors数组为A, 实现A-B的渐变线, 则colors数组传入A, B
 */
@property (nonatomic, strong) NSArray <UIColor *> *colors;

/**
 *  @brief  轨迹高亮时间, 单位:毫秒 取值大于等于0, 等于0时无动画, 默认200ms
 */
@property (nonatomic, assign) int highlightDuration;

/**
 *  @brief  设置动画开始和结束时间
 *  @param  startTime 动画开始时间, 取值大于等于0且小于结束时间，单位:毫秒 , 默认0,
 *  @param  endTime      动画结束时间，单位:毫秒，默认2000ms
 */
-(void)setAnimationStartTime:(int)startTime animationEndTime:(int)endTime;

/**
 *  @brief  动画速率, 取值大于0， 默认 1
 */
@property (nonatomic, assign) CGFloat animateRatio;

/**
 *  @brief  轨迹线线宽, 单位: point, 默认值 2
 */
@property (nonatomic, assign) CGFloat width;

@end

/**
 *  @brief 轨迹的单个点
 */
@interface QTrailNode : NSObject

/**
 *  @brief  轨迹点的地理坐标
 */
@property (nonatomic, assign) CLLocationCoordinate2D coordinate;

/**
 *  @brief  轨迹点的时间戳, 取值大于等于0
 */
@property (nonatomic, assign) int timeStamp;

@end

/**
 *  @brief  单条轨迹线数据
 */
@interface QTrailLine : NSObject

/**
 *  @brief  轨迹线的数据点, 数据中的时间戳需保证递增顺序
 */
@property (nonatomic, strong) NSArray <QTrailNode *> *nodes;

@end

/**
 *  @brief  轨迹类型overlay, 与QTrailIOverlayView搭配使用
 */
@interface QTrailOverlay : QGLOverlay

/**
 *  @brief  生成轨迹overlay
 *  @param  lines   轨迹数据
 */
- (instancetype)initWithTrailData:(NSArray <QTrailLine *> *)lines;

/**
 *  @brief  轨迹线数据
 */
@property (nonatomic, copy) NSArray <QTrailLine *> *lines;

/**
 *  @brief  轨迹线样式
 */
@property (nonatomic, strong) QTrailLineStyle *style;

@end

NS_ASSUME_NONNULL_END
