//
//  QMaskingLayerOutlineArea.h
//  QMapKit
//
//  Created by halldwang on 2025/8/15.
//  Copyright © 2025 tencent. All rights reserved.
//

#import "QPolygonView.h"

NS_ASSUME_NONNULL_BEGIN

/// 非蒙层区域的轮廓配置
@interface QMaskingLayerOutlineArea : NSObject {
    @package
    QMapPoint *_points;
    NSUInteger _pointCount;
    QMapRect _boundingRect;
    CLLocationCoordinate2D *_coordinates;
}

/// 非蒙层区域的轮廓初始化
/// - Parameters:
///   - coords: 轮廓点
///   - count: 轮廓点数量
///   - buffer: 向外扩展区域，>= 0
- (instancetype)initWithCoordinates:(CLLocationCoordinate2D *)coords count:(NSUInteger)count buffer:(CGFloat)buffer;

/// 非蒙层区域的轮廓初始化
/// - Parameters:
///   - coords: 轮廓点
///   - count: 轮廓点数量
///   - buffer: 向外扩展区域，>= 0
- (instancetype)initWithPoints:(const QMapPoint *)points count:(NSUInteger)count buffer:(CGFloat)buffer;

/**
 * @brief  坐标点数组
 */
@property (nonatomic, readonly) QMapPoint *points;

/**
 * @brief  坐标点个数
 */
@property (nonatomic, readonly) NSUInteger pointCount;

/**
 * @brief  坐标点数组 (CLLocationCoordinate2D 格式)
 */
@property (nonatomic, readonly) CLLocationCoordinate2D *coordinates;


/// buffer 向外扩展区域，>= 0
@property (nonatomic, assign) CGFloat buffer;

@end


NS_ASSUME_NONNULL_END
