//
//  InvertGeoViewController.m
//  QMapKitDebugging
//
//  Created by Keith Cao on 2019/8/5.
//  Copyright © 2019 tencent. All rights reserved.
//

#import "InvertGeoViewController.h"
#import "QPoiAnnotation.h"
#import <QMapKit/QMSSearchKit.h>

#define ADDRESS @"北京市海淀区彩和坊路海淀西大街74号"

@interface InvertGeoViewController ()<QMSSearchDelegate>

@property (nonatomic, strong) QMSSearcher *mySearcher;

@property (nonatomic, strong) QMSGeoCodeSearchResult *geoCodeResult;

@end

@implementation InvertGeoViewController

- (void)buttonClicked
{
    QMSGeoCodeSearchOption *geoOption = [[QMSGeoCodeSearchOption alloc] init];
    [geoOption setAddress:ADDRESS];
    [geoOption setRegion:@"北京"];
    
    [self.mySearcher searchWithGeoCodeSearchOption:geoOption];
}

#pragma mark - AnnotationSetUp

- (void)setUpAnnotation
{
    [self.mapView setCenterCoordinate:self.geoCodeResult.location animated:YES];
    
	QPoiAnnotation *annotation = [[QPoiAnnotation alloc] initWithPoiData:self.geoCodeResult];
    annotation.coordinate = self.geoCodeResult.location;
    [annotation setTitle:[NSString stringWithFormat:@"%@%@%@%@", self.geoCodeResult.address_components.city, self.geoCodeResult.address_components.district, self.geoCodeResult.address_components.street, self.geoCodeResult.address_components.street_number]];
    [annotation setSubtitle:[NSString stringWithFormat:@"lat:%f, lng:%f", self.geoCodeResult.location.latitude, self.geoCodeResult.location.longitude]];
    
    [self.mapView addAnnotation:annotation];
    
}

- (QAnnotationView *)mapView:(QMapView *)mapView viewForAnnotation:(id<QAnnotation>)annotation
{if ([annotation isKindOfClass:[QPointAnnotation class]])
{
	static NSString *pointReuseIndetifier = @"pointReuseIndetifier";
	QPinAnnotationView *annotationView = (QPinAnnotationView*)[self.mapView dequeueReusableAnnotationViewWithIdentifier:pointReuseIndetifier];
	
	if (annotationView == nil)
	{
		annotationView = [[QPinAnnotationView alloc] initWithAnnotation:annotation reuseIdentifier:pointReuseIndetifier];
	}
	
	// 可拖拽.
	//		annotationView.draggable = YES;
	
	annotationView.canShowCallout = YES;
	
	// 开启下落动画
	annotationView.animatesDrop = YES;
	
	return annotationView;
}
	
	return nil;
}

#pragma mark - GeoCodeSearchOptionDelegate

- (void)searchWithSearchOption:(QMSSearchOption *)searchOption didFailWithError:(NSError *)error
{
    NSLog(@"error: %@",error);
}

- (void)searchWithGeoCodeSearchOption:(QMSGeoCodeSearchOption *)geoCodeSearchOption didReceiveResult:(QMSGeoCodeSearchResult *)geoCodeSearchResult
{
    self.geoCodeResult = geoCodeSearchResult;
    
    NSLog(@"geoCodeResult: %@", geoCodeSearchResult);
    
    [self setUpAnnotation];
}


- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.mySearcher = [[QMSSearcher alloc] initWithDelegate:self];
    
    UIView *viewForLabel = [[UIView alloc] initWithFrame:CGRectMake(self.mapView.frame.origin.x, self.mapView.frame.origin.y, self.mapView.frame.size.width, 50)];
    
    UIButton *button = [[UIButton alloc] initWithFrame:CGRectMake(viewForLabel.frame.origin.x, viewForLabel.frame.origin.y, viewForLabel.frame.size.width, viewForLabel.frame.size.height)];
    button.layer.borderWidth = 2;
    button.backgroundColor = [UIColor blackColor];
    
    [button setTitle:@"点击添加北京市海淀区彩和坊路海淀西大街74号" forState:UIControlStateNormal];
    [button addTarget:self action:@selector(buttonClicked) forControlEvents:UIControlEventTouchUpInside];
    [viewForLabel addSubview:button];
    [self.mapView addSubview:viewForLabel];
}

@end
