//
//  TexturePolylineViewController.m
//  QMapKitDebugging
//
//  Created by fan on 2017/7/20.
//  Copyright © 2017年 tencent. All rights reserved.
//

#import "TexturePolylineViewController.h"

typedef NS_ENUM(NSUInteger, TestPolylineType)
{
	// QTexturePolylineView + ColorLine + 实线
	TypeSolidTexturePolyline,
	// QTexturePolylineView + ColorLine + 虚线
	TypeDashedTexturePolyline,
	// QTexturePolylineView + SliceAsBackground
	TypeSliceAsBackgroundTexturePolyline,
	// QTexturePolylineView + RepeatDraw
	TypeRepeatTexturePolyline,
	// QTexturePolylineView + FootPrint
	TypeFootprintTexturePolyline,
	TypeMax
};

@implementation QRouteOverlay

@end

#pragma mark - Demo

@interface TexturePolylineViewController ()

@property (nonatomic, strong) NSMutableArray *overlays;

@end

@implementation TexturePolylineViewController

// 实线 + ColorLine 模式.
- (QOverlayView *)createSolidColorLineTexturePolylineView:(id<QOverlay>)overlay
{
	if (overlay == nil) return nil;
	
	QTexturePolylineView *polylineView = [[QTexturePolylineView alloc] initWithPolyline:overlay];
	polylineView.drawType = QTextureLineDrawType_ColorLine;
	polylineView.strokeColor = [UIColor blueColor];
	polylineView.lineWidth = 20;
	polylineView.borderColor = [UIColor greenColor];
	polylineView.borderWidth = 4;
	
	QPolyline *polyline = (QPolyline *)overlay;
	NSMutableArray<QSegmentColor *> *colors = [NSMutableArray array];
	for (int i = 0; i < polyline.pointCount - 1; i++)
	{
		QSegmentColor *color = [[QSegmentColor alloc] init];
		color.startIndex = i;
		color.endIndex = i + 1;
		
		if (i % 2 == 0)
		{
			color.color = [UIColor greenColor];
		}
		else
		{
			color.color = [UIColor blueColor];
		}
		
		
		[colors addObject:color];
	}
	
	polylineView.segmentColor = colors;
	
	return polylineView;
}

// 实线 + ColorLine 模式.
- (QOverlayView *)createDashColorLineTexturePolylineView:(id<QOverlay>)overlay
{
	if (overlay == nil) return nil;
	
	QTexturePolylineView *polylineView = [[QTexturePolylineView alloc] initWithPolyline:overlay];
	polylineView.drawType = QTextureLineDrawType_ColorLine;
	polylineView.strokeColor = [UIColor blueColor];
	polylineView.lineWidth = 20;
	polylineView.borderColor = [UIColor greenColor];
	polylineView.borderWidth = 4;
	
	QPolyline *polyline = (QPolyline *)overlay;
	NSMutableArray<QSegmentColor *> *colors = [NSMutableArray array];
	for (int i = 0; i < polyline.pointCount - 1; i++)
	{
		QSegmentColor *color = [[QSegmentColor alloc] init];
		color.startIndex = i;
		color.endIndex = i + 1;
		
		if (i % 2 == 0)
		{
			color.color = [UIColor greenColor];
		}
		else
		{
			color.color = [UIColor blueColor];
		}
		
		
		[colors addObject:color];
	}
	
	polylineView.segmentColor = colors;
	
	polylineView.lineDashPattern = @[@(30), @(10)];
	
	return polylineView;
}

// QDrawType_SliceAsBackground 模式.
- (QOverlayView *)createSliceAsBackgroundTexturePolylineView:(id<QOverlay>)overlay
{
	if (overlay == nil) return nil;
	
	QTexturePolylineView *polylineView = [[QTexturePolylineView alloc] initWithPolyline:overlay];
	polylineView.drawType = QTextureLineDrawType_SliceAsBackground;
	polylineView.lineWidth = 20;
	
	QPolyline *polyline = (QPolyline *)overlay;
	NSMutableArray<QSegmentStyle*> *styles = [NSMutableArray array];
	for (int i = 0; i < polyline.pointCount - 1; i++)
	{
		QSegmentStyle *color = [[QSegmentStyle alloc] init];
		color.startIndex = i;
		color.endIndex = i + 1;
		
		color.colorImageIndex = i % 10;
		
		[styles addObject:color];
	}
	
	polylineView.segmentStyle = styles;
	
	return polylineView;
}

// QTextureLineDrawType_RepeatDraw 模式.
- (QOverlayView *)createRepeatDrawTexturePolylineView:(id<QOverlay>)overlay
{
	if (overlay == nil) return nil;
	
	QTexturePolylineView *polylineView = [[QTexturePolylineView alloc] initWithPolyline:overlay];
	polylineView.drawType = QTextureLineDrawType_RepeatDraw;
	polylineView.lineWidth = 20;
	
	QPolyline *polyline = (QPolyline *)overlay;
	NSMutableArray<QSegmentStyle*> *styles = [NSMutableArray array];
	for (int i = 0; i < polyline.pointCount - 1; i++)
	{
		QSegmentStyle *color = [[QSegmentStyle alloc] init];
		color.startIndex = i;
		color.endIndex = i + 1;
		
		color.colorImageIndex = i % 10;
		
		[styles addObject:color];
	}
	
	polylineView.segmentStyle = styles;
	
	polylineView.styleTextureImage = [UIImage imageNamed:@"ball.png"];
	
	return polylineView;
}

// QTextureLineDrawType_FootPrint 模式.
- (QOverlayView *)createFootprintTexturePolylineView:(id<QOverlay>)overlay
{
	if (overlay == nil) return nil;
	
	QTexturePolylineView *polylineView = [[QTexturePolylineView alloc] initWithPolyline:overlay];
	polylineView.drawType = QTextureLineDrawType_FootPrint;
	polylineView.lineWidth = 20;
	
	QPolyline *polyline = (QPolyline *)overlay;
	NSMutableArray<QSegmentStyle*> *styles = [NSMutableArray array];
	for (int i = 0; i < polyline.pointCount - 1; i++)
	{
		QSegmentStyle *color = [[QSegmentStyle alloc] init];
		color.startIndex = i;
		color.endIndex = i + 1;
		
		color.colorImageIndex = i % 10;
		
		[styles addObject:color];
	}
	
	polylineView.segmentStyle = styles;
	
	polylineView.styleTextureImage = [UIImage imageNamed:@"foot.jpg"];
	
	return polylineView;
}

#pragma mark - QMapViewDelegate

- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay
{
	if ([overlay isKindOfClass:[QPolyline class]])
	{
		QPolyline *polyline = (QPolyline *)overlay;
		TestPolylineType type = [polyline.userData intValue];
		
		QOverlayView *view = nil;
		
		if (type == TypeSolidTexturePolyline)
		{
			view = [self createSolidColorLineTexturePolylineView:overlay];
		}
		else if (type == TypeDashedTexturePolyline)
		{
			view = [self createDashColorLineTexturePolylineView:overlay];
		}
		else if (type == TypeSliceAsBackgroundTexturePolyline)
		{
			view = [self createSliceAsBackgroundTexturePolylineView:overlay];
		}
		else if (type == TypeRepeatTexturePolyline)
		{
			view = [self createRepeatDrawTexturePolylineView:overlay];
		}
		else if (type == TypeFootprintTexturePolyline)
		{
			view = [self createFootprintTexturePolylineView:overlay];
		}
		
		[(QOverlayPathView *)view setAlpha:0.5];
		
		return view;
	}
	
	return nil;
}

#pragma mark - Setup

- (void)setupOverlays
{
	self.overlays = [NSMutableArray array];
	
	const NSInteger cnt = 6;
	
	CLLocationCoordinate2D polylineCoords[cnt];
	polylineCoords[0].latitude = 39.9442;
	polylineCoords[0].longitude = 116.324;
	
	polylineCoords[1].latitude = 39.9442;
	polylineCoords[1].longitude = 116.444;
	
	polylineCoords[2].latitude = 39.9042;
	polylineCoords[2].longitude = 116.454;
	
	polylineCoords[3].latitude = 39.9042;
	polylineCoords[3].longitude = 116.334;
	
	polylineCoords[4].latitude = 39.8442;
	polylineCoords[4].longitude = 116.334;
	
	polylineCoords[5].latitude = 39.8442;
	polylineCoords[5].longitude = 116.434;
	
	for (int i = 0; i < TypeMax; i++)
	{
		for (int j = 0; j < cnt; j++)
		{
			polylineCoords[j].longitude += 0.2;
		}
		
		QPolyline *polyline = [QPolyline polylineWithCoordinates:polylineCoords count:cnt];
		polyline.userData = @(i);
		
		[self.overlays addObject:polyline];
	}
}

- (void)viewDidLoad
{
	[super viewDidLoad];
	
	[self setupOverlays];
	
	[self.mapView addOverlays:self.overlays];
	
	QMapRect mapRect = QMapRectNull;
	for (int i = 0; i < self.overlays.count; i++)
	{
		if (QMapRectIsEmpty(mapRect))
		{
			mapRect = [self.overlays[i] boundingMapRect];
		}
		else
		{
			mapRect = QMapRectUnion(mapRect, [self.overlays[i] boundingMapRect]);
		}
	}
	
	[self.mapView setVisibleMapRect:mapRect edgePadding:UIEdgeInsetsMake(20, 40, 20, 40) animated:YES];
}

@end
