//
//  PolylineViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2023/10/16.
//  Copyright © 2023 tencent. All rights reserved.
//

#import "PolylineViewController.h"

@interface PolylineViewController ()

@end

@implementation PolylineViewController

- (void)viewDidLoad {
    [super viewDidLoad];
	
	[self setUpPolyline];
}


- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay
{
	if ([overlay isKindOfClass:[QPolyline class]])
	{
		QPolyline *polyline = (QPolyline *)overlay;
		
		QPolylineView *polylineView = [[QPolylineView alloc] initWithPolyline:overlay];
		polylineView.fillColor = [[UIColor redColor] colorWithAlphaComponent:0.5];
		polylineView.strokeColor = [[UIColor blueColor] colorWithAlphaComponent:0.5];
		polylineView.lineWidth = 20;
		polylineView.borderColor = [[UIColor greenColor] colorWithAlphaComponent:0.5];
		polylineView.borderWidth = 4;
		
		
		NSMutableArray<QSegmentText *> *segmentTexts = [NSMutableArray array];
		for (int i = 0; i < polyline.pointCount - 1; i++)
		{
			QSegmentText *segmentText = [[QSegmentText alloc] init];
			segmentText.startIndex = i;
			segmentText.endIndex = i + 1;
			segmentText.name = [NSString stringWithFormat:@"Road %d", i];
			[segmentTexts addObject:segmentText];
		}
		
		polylineView.text = [[QText alloc] initWithSegments:segmentTexts];
		
		polylineView.displayLevel = QOverlayLevelAboveRoads;
		
		
		return polylineView;

	}
	
	return nil;
}

- (void)setUpPolyline
{
	const NSInteger cnt = 6;
	
	CLLocationCoordinate2D polylineCoords[cnt];
	polylineCoords[0].latitude = 39.9442;
	polylineCoords[0].longitude = 116.324;
	
	polylineCoords[1].latitude = 39.9442;
	polylineCoords[1].longitude = 116.444;
	
	polylineCoords[2].latitude = 39.9042;
	polylineCoords[2].longitude = 116.454;
	
	polylineCoords[3].latitude = 39.9042;
	polylineCoords[3].longitude = 116.334;
	
	polylineCoords[4].latitude = 39.8442;
	polylineCoords[4].longitude = 116.334;
	
	polylineCoords[5].latitude = 39.8442;
	polylineCoords[5].longitude = 116.434;
	
	QPolyline *polyline = [QPolyline polylineWithCoordinates:polylineCoords count:cnt];
	
	[self.mapView addOverlay:polyline];
	
	[self.mapView setVisibleMapRect:polyline.boundingMapRect edgePadding:UIEdgeInsetsMake(20, 20, 20, 40) animated:YES];
}

@end
