//
//  GradientLineViewController.m
//  QMapKitDebugging
//
//  Created by Keith Cao on 2021/1/26.
//  Copyright © 2021 tencent. All rights reserved.
//

#import "GradientLineViewController.h"
#import <QMapKit/QMSSearchKit.h>



@interface GradientLineViewController ()

@property (nonatomic, strong) QPolyline *testLine;

@end

@implementation GradientLineViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUpPolyline];
    
    [self.mapView setVisibleMapRect:self.testLine.boundingMapRect edgePadding:UIEdgeInsetsZero animated:YES];
}

- (NSArray *)generateSeg
{
	NSArray *colors = [NSArray arrayWithObjects:[UIColor redColor],[UIColor greenColor],[UIColor orangeColor],[UIColor purpleColor], [UIColor blueColor], nil];
    NSMutableArray *seg = [[NSMutableArray alloc] init];
    
    int poinCount = (int)self.testLine.pointCount;
	for (int i = 0; i < poinCount - 1; i ++)
	{
		QSegmentColor *segColor = [[QSegmentColor alloc] init];
		segColor.startIndex = i;
		segColor.endIndex = i + 1;
		segColor.color = colors[arc4random() % 5];
		[seg addObject:segColor];
	}
    return seg;
}

- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay
{
	if ([overlay isKindOfClass:[QPolyline class]])
	{
		QTexturePolylineView *render = [[QTexturePolylineView alloc] initWithPolyline:overlay];
		render.lineWidth = 10;
        render.drawType = QTextureLineDrawType_ColorLine;
		// 分段颜色
        NSArray *sg = [self generateSeg];
        render.segmentColor = sg;
        render.drawSymbol = YES;
		// 是否使用渐变
		render.useGradient = YES;
        
		return render;
		
	}
	
	return nil;
}

- (void)setUpPolyline
{
	/* Polyline 1. */
	CLLocationCoordinate2D polylineCoords[6];
	polylineCoords[0].latitude = 39.9442;
	polylineCoords[0].longitude = 116.324;
	
	polylineCoords[1].latitude = 39.9442;
	polylineCoords[1].longitude = 116.444;
	
	polylineCoords[2].latitude = 39.9042;
	polylineCoords[2].longitude = 116.454;
	
	polylineCoords[3].latitude = 39.9042;
	polylineCoords[3].longitude = 116.334;
	
	polylineCoords[4].latitude = 39.8442;
	polylineCoords[4].longitude = 116.334;
	
	polylineCoords[5].latitude = 39.8442;
	polylineCoords[5].longitude = 116.434;
	
	self.testLine = [[QPolyline alloc] initWithCoordinates:polylineCoords count:6];
	[self.mapView addOverlay:self.testLine];
	
}

@end
