//
//  TrafficStyleViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2020/9/3.
//  Copyright © 2020 tencent. All rights reserved.
//

#import "TrafficStyleViewController.h"

@interface TrafficStyleViewController ()

@end

@implementation TrafficStyleViewController

- (void)viewDidLoad {
    [super viewDidLoad];
	
	[self setupMapView];
    // Do any additional setup after loading the view.
}

- (void)setupMapView
{
	// 设置路况样式
	QTrafficStyle *style = [[QTrafficStyle alloc] init];
	
	style.borderWidth = 2;
	style.lineWidth = 2;
	
	// 通畅路况配色
	style.smoothColor = [UIColor cyanColor];
	style.smoothBorderColor = [UIColor blackColor];
	
	// 缓慢路况配色
	style.slowBorderColor = [UIColor blackColor];
	style.slowColor = [UIColor grayColor];
	
	// 拥堵路况配色
	style.congestedColor = [UIColor orangeColor];
	style.congestedBorderColor = [UIColor blackColor];
	
	// 严重拥堵路况配色
	style.seriouseCongestedBorderColor = [UIColor blackColor];
	style.seriouseCongestedColor = [UIColor blackColor];
	
	QMapConfig *cfg = [[QMapConfig alloc] initWithSubID:nil subKey:nil];
	// 将自定义路况样式赋值到地图配置中
	cfg.trafficStyle = style;
	
	QMapView *mapView = [[QMapView alloc]
					initWithFrame: CGRectMake(0,
											  0,
											  CGRectGetWidth(self.view.frame),
											  CGRectGetHeight(self.view.frame) - CGRectGetMaxY(self.navigationController.navigationBar.frame)) config:cfg];
	
	mapView.showsTraffic     = YES;
	
	[self.view addSubview:mapView];
	
}

@end
