//
//  QCoordinateTools.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2023/10/18.
//  Copyright © 2023 tencent. All rights reserved.
//

#import "QSearchTools.h"
#import <QMapKit/QMapKit.h>

@implementation QSearchTools

+ (CLLocationCoordinate2D)decodeCoordinateValue:(NSValue *)obj
{
	CLLocationCoordinate2D coordinate;
	
	if ([obj isKindOfClass:[[NSValue valueWithBytes:&coordinate objCType:@encode(CLLocationCoordinate2D)] class]]) {
		
		[obj getValue:(void *)&coordinate];
	}
	
	return CLLocationCoordinate2DMake(coordinate.latitude, coordinate.longitude);
}

+ (NSArray *)getSegmentStyleFromRouteStep:(NSArray <QMSRouteStep *> *)routeSteps
{
	NSMutableArray *segmentStyles = [NSMutableArray array];
	for (QMSRouteStep *step in routeSteps)
	{
		QSegmentStyle * style = [[QSegmentStyle alloc] init];
		style.startIndex = [step.polyline_idx.firstObject intValue];
		style.endIndex = [step.polyline_idx.lastObject intValue];
		style.colorImageIndex = arc4random() % 6;	// 颜色可以自定义
		
		[segmentStyles addObject:style];
	}
	
	return [segmentStyles copy];
}

+ (NSArray *)getSegmentColorsFromRouteCondition:(NSArray<QMSTrafficCondition *> *)condition
{
	NSMutableArray *segmentColors = [NSMutableArray array];
	
	NSArray *colors = @[[UIColor colorWithRed:138/255.0 green:217/255.0 blue:28/255.0 alpha:1], 	/// 顺畅
						[UIColor colorWithRed:244/255.0 green:247/255.0 blue:89/255.0 alpha:1],		/// 缓慢
						[UIColor colorWithRed:250/255.0 green:154/255.0 blue:0 alpha:1],			/// 拥堵
						[UIColor colorWithRed:138/255.0 green:217/255.0 blue:28/255.0 alpha:1],		/// 无路况
						[UIColor colorWithRed:255/255.0 green:0 blue:0 alpha:1]						/// 严重拥堵
	];
	
	for (QMSTrafficCondition *traffic in condition) {
		QSegmentColor *sgColor = [[QSegmentColor alloc] init];
		sgColor.startIndex = [traffic.polyline_idx.firstObject intValue];
		sgColor.endIndex = [traffic.polyline_idx.lastObject intValue];
		sgColor.color = colors[traffic.level];
		[segmentColors addObject:sgColor];
	}
	
	return [segmentColors copy];
}

@end
