//
//  QCoordinateTools.h
//  QMapKitDemo
//
//  Created by Keith Cao on 2023/10/18.
//  Copyright © 2023 tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>
#import <QMapKit/QMSSearchKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface QSearchTools : NSObject

/// 转换Endcode后的经纬度值
+ (CLLocationCoordinate2D)decodeCoordinateValue:(NSValue *)obj;

+ (NSArray *)getSegmentStyleFromRouteStep:(NSArray <QMSRouteStep *> *)routeSteps;

+ (NSArray *)getSegmentColorsFromRouteCondition:(NSArray <QMSTrafficCondition *> *)condition;

@end

NS_ASSUME_NONNULL_END
