//
//  QMapView+MultiLanguage.h
//  QMapKit
//
//  Created by Keith Cao on 2023/6/26.
//  Copyright © 2023 tencent. All rights reserved.
//

#import <QMapKit/QMapKit.h>

NS_ASSUME_NONNULL_BEGIN

/**
 *	@brief 地图底图文字语言选项
 */
typedef NS_ENUM(NSInteger, QMapMultiLanguage){
	QMapMultiLanguageChinese,				///< 简体中文
	QMapMultiLanguageEnglish,				///< 英文
	QMapMultiLanguageChineseTraditional		///< 繁体中文
};

@interface QMapView (MultiLanguage)

/**
 * @brief 指定底图文字的首选语言
 *
 * 指定底图文字的语言，默认采用中文
 *
 * @param language 指定的语言
 * @see QMapMultiLanguage
 */
- (void)setMapLanguage:(QMapMultiLanguage)language;

/**
 * @brief 获取底图文字的首选语言
 *
 */
- (QMapMultiLanguage)getMapLanguage;

@end

NS_ASSUME_NONNULL_END
