//
//  AnnotationTranslationViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2023/10/23.
//  Copyright © 2023 tencent. All rights reserved.
//

#import "AnnotationTranslationViewController.h"

#define Degree2Radian(degree) ( M_PI * (degree) / 180 )

@implementation QMUCarTranlatePoint


@end

@interface AnnotationTranslationViewController ()

@property (nonatomic, strong) QPointAnnotation *carAnno;

@property (nonatomic, strong) QPolyline *polyline;

@property (nonatomic, strong) NSMutableArray <QMUCarTranlatePoint *> *translatePoints;

@end

@implementation AnnotationTranslationViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
	
	[self setUpRoutePolyline];
	
}

- (void)setUpRoutePolyline
{
	const NSInteger cnt = 6;
	
	CLLocationCoordinate2D polylineCoords[cnt];
	polylineCoords[0].latitude = 39.9442;
	polylineCoords[0].longitude = 116.324;
	
	polylineCoords[1].latitude = 39.9442;
	polylineCoords[1].longitude = 116.444;
	
	polylineCoords[2].latitude = 39.9042;
	polylineCoords[2].longitude = 116.454;
	
	polylineCoords[3].latitude = 39.9042;
	polylineCoords[3].longitude = 116.334;
	
	polylineCoords[4].latitude = 39.8442;
	polylineCoords[4].longitude = 116.334;
	
	polylineCoords[5].latitude = 39.8442;
	polylineCoords[5].longitude = 116.434;
	
	self.polyline = [QPolyline polylineWithCoordinates:polylineCoords count:cnt];
	
	[self.mapView addOverlay:self.polyline];
	
	[self setUpAnnotation:polylineCoords[0]];
	
	[self.mapView setVisibleMapRect:self.polyline.boundingMapRect edgePadding:UIEdgeInsetsMake(20, 20, 20, 40) animated:YES];
	
	// 创建平移路线点数组
	self.translatePoints = [NSMutableArray array];
	
	for (int i = 0; i < cnt; i ++)
	{
		QMUCarTranlatePoint *p = [[QMUCarTranlatePoint alloc] init];
		p.coordinate = polylineCoords[i];
		
		[self.translatePoints addObject:p];
	}
}

- (void)setUpAnnotation:(CLLocationCoordinate2D)coordinate
{
	_carAnno = [[QPointAnnotation alloc] init];
	_carAnno.coordinate = coordinate;
	
	[self.mapView addAnnotation:_carAnno];
}

- (void)handleTestAction
{
	[self executeTranslate];
}

- (NSString *)testTitle
{
	return @"执行平移动画";
}

#pragma mark -- Translate Utils

- (void)executeTranslate
{
	QAnnotationView *carView = (QAnnotationView *)[self.mapView viewForAnnotation:self.carAnno];
	
	__weak typeof (self) ws = self;
	[QMUAnnotationAnimator translateWithAnnotationView:carView rotationView:carView locations:self.translatePoints duration:10 rotateEnabled:YES distanceFilter:0 translationCallback:^(QMUAnnotationAnimationInfo info) {
		NSString *status = info.status == QMUAnnotationAnimation_Interpolating ? @"插值" : @"完成";
		
		NSLog(@"translate coord:%f,%f, index:%d, status:%@ self:%p", info.coordinate.latitude, info.coordinate.longitude, info.index, status, ws);
		
		// 进行线擦除
		QTexturePolylineView *tv = (QTexturePolylineView *)[ws.mapView viewForOverlay:ws.polyline];
		
		[tv eraseFromStartToCurrentPoint:info.coordinate searchFrom:info.index toColor:YES];
			
	}];
}

#pragma mark -- MapDelegate

- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay
{
	if (overlay == nil) return nil;
	
	QTexturePolylineView *polylineView = [[QTexturePolylineView alloc] initWithPolyline:overlay];
	polylineView.drawType = QTextureLineDrawType_ColorLine;
	polylineView.strokeColor = [UIColor blueColor];
	polylineView.lineWidth = 20;
	polylineView.borderColor = [UIColor greenColor];
	polylineView.borderWidth = 4;
	
	QPolyline *polyline = (QPolyline *)overlay;
	NSMutableArray<QSegmentColor *> *colors = [NSMutableArray array];
	for (int i = 0; i < polyline.pointCount - 1; i++)
	{
		QSegmentColor *color = [[QSegmentColor alloc] init];
		color.startIndex = i;
		color.endIndex = i + 1;
		
		if (i % 2 == 0)
		{
			color.color = [UIColor greenColor];
		}
		else
		{
			color.color = [UIColor blueColor];
		}
		
		
		[colors addObject:color];
	}
	
	polylineView.segmentColor = colors;
	
	return polylineView;
}

- (QAnnotationView *)mapView:(QMapView *)mapView viewForAnnotation:(id<QAnnotation>)annotation
{
	if ([annotation isKindOfClass:[QPointAnnotation class]])
	{
		static NSString *pointReuseIndetifier = @"pointReuseIndetifier";
		QAnnotationView *annotationView = (QAnnotationView*)[self.mapView dequeueReusableAnnotationViewWithIdentifier:pointReuseIndetifier];
		
		if (annotationView == nil)
		{
			annotationView = [[QAnnotationView alloc] initWithAnnotation:annotation reuseIdentifier:pointReuseIndetifier];
		}
		
		// 平移动画图片的车头需正比朝向
		UIImage *img = [UIImage imageNamed:@"map_icon_driver@3x"];
		
		annotationView.image = img;
		
		return annotationView;
	}
	
	return nil;
}

@end
