//
//  PolygonWithHoleViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2023/10/16.
//  Copyright © 2023 tencent. All rights reserved.
//

#import "PolygonWithHoleViewController.h"

@interface PolygonWithHoleViewController ()

@property (nonatomic, strong) QPolygon *polygon;

@end

@implementation PolygonWithHoleViewController

- (NSString *)testTitle {
	return @"更新洞";
}

- (void)handleTestAction
{
	NSMutableArray *holes = [NSMutableArray array];
	
	{
		CLLocationCoordinate2D coordinates[3];
		coordinates[0] = CLLocationCoordinate2DMake(39.808043, 116.386581);
		coordinates[1] = CLLocationCoordinate2DMake(39.815462, 116.353761);
		coordinates[2] = CLLocationCoordinate2DMake(39.840601, 116.378632);
		
		// 创建洞
		QPolygon *hole = [QPolygon polygonWithCoordinates:coordinates count:sizeof(coordinates)/sizeof(CLLocationCoordinate2D)];
		[holes addObject:hole];
	}
	
	{
		CLLocationCoordinate2D coordinates[5];
		coordinates[0] = CLLocationCoordinate2DMake(39.894132, 116.384103);
		coordinates[1] = CLLocationCoordinate2DMake(39.889935, 116.336667);
		coordinates[2] = CLLocationCoordinate2DMake(39.872751, 116.360769);
		coordinates[3] = CLLocationCoordinate2DMake(39.850379, 116.348718);
		coordinates[4] = CLLocationCoordinate2DMake(39.877670, 116.378632);
		
		// 创建洞
		QPolygon *hole = [QPolygon polygonWithCoordinates:coordinates count:sizeof(coordinates)/sizeof(CLLocationCoordinate2D)];
		[holes addObject:hole];
	}
	
	// 更新洞
	self.polygon.interiorPolygons = holes;
	
}

- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay
{
	if ([overlay isKindOfClass:[QPolygon class]])
	{
		QPolygonView *polygonRender = [[QPolygonView alloc] initWithPolygon:overlay];
		polygonRender.lineWidth   = 3;
		polygonRender.strokeColor = [UIColor colorWithRed:1 green:0 blue:0 alpha:1];
		polygonRender.fillColor   = [[UIColor greenColor] colorWithAlphaComponent:0.4];
		polygonRender.lineType = QOverlayStrokeType_Default;
		return polygonRender;
	}
	
	return nil;
}

- (void)viewDidLoad
{
	[super viewDidLoad];
	
	self.polygon = [self constructHolePolygon];
	
	[self.mapView addOverlay:self.polygon];
	
	[self.mapView setVisibleMapRect:self.polygon.boundingMapRect edgePadding:UIEdgeInsetsZero animated:YES];
}

#pragma mark -- Tools
- (QPolygon *)constructHolePolygon
{
	// 多边形的外轮廓.
	CLLocationCoordinate2D coordinates[4] = {
		CLLocationCoordinate2DMake(39.8, 116.3),
		CLLocationCoordinate2DMake(39.9, 116.3),
		CLLocationCoordinate2DMake(39.9, 116.4),
		CLLocationCoordinate2DMake(39.8, 116.4)
	};
	
	NSMutableArray<QPolygon *> *holes = [NSMutableArray array];
	
	// 洞
	{
		// 多边形内的洞.
		CLLocationCoordinate2D coordinates[3] = {
			CLLocationCoordinate2DMake(39.82, 116.32),
			CLLocationCoordinate2DMake(39.83, 116.35),
			CLLocationCoordinate2DMake(39.87, 116.38)
		};
		
		// 创建洞
		QPolygon *hole = [QPolygon polygonWithCoordinates:coordinates  count:sizeof(coordinates)/sizeof(CLLocationCoordinate2D)];
		[holes addObject:hole];
	}
	
	// 洞
	{
		CLLocationCoordinate2D coordinates[4];
		coordinates[0] = CLLocationCoordinate2DMake(39.844605, 116.315727);
		coordinates[1] = CLLocationCoordinate2DMake(39.875309, 116.315385);
		coordinates[2] = CLLocationCoordinate2DMake(39.885344, 116.357778);
		coordinates[3] = CLLocationCoordinate2DMake(39.856219, 116.346325);
		
		// 创建洞
		QPolygon *hole = [QPolygon polygonWithCoordinates:coordinates  count:sizeof(coordinates)/sizeof(CLLocationCoordinate2D)];
		[holes addObject:hole];
	}
	
	// 创建带洞多边形.
	QPolygon *polygon = [QPolygon polygonWithCoordinates:coordinates  count:sizeof(coordinates)/sizeof(CLLocationCoordinate2D)];
	polygon.interiorPolygons = holes;
	
	return polygon;
}

@end
