//
//  GroundOverlayController.m
//  QMapKitDemo
//
//  Created by v_hefang on 2020/5/28.
//  Copyright © 2020 tencent. All rights reserved.
//

#import "GroundOverlayController.h"

@interface GroundOverlayController ()
@property (nonatomic, strong) QGroundOverlayView *groundOverlayView;
@property (nonatomic, assign) NSInteger index;
@end

@implementation GroundOverlayController

- (NSString *)testTitle {
    return @"调增层级";
}

- (void)handleTestAction {
    _index++;
    if (_index == 3) {
        _index = 0;
    }
    _groundOverlayView.displayLevel = _index;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    _index = 0;
    
    [self.mapView setCenterCoordinate:CLLocationCoordinate2DMake(40.040219,116.273348)];
    [self.mapView setZoomLevel:17];
    [self setupGroundOverlay];
}

- (void)setupGroundOverlay {
    
//    QCoordinateBounds bounds;
//    bounds.northEast = CLLocationCoordinate2DMake(40.041936,116.274711);
//    bounds.southWest = CLLocationCoordinate2DMake(40.03865,116.271739);
    
//    QGroundOverlay *overlay = [QGroundOverlay groundOverlayWithBounds:bounds icon:image];
//    [self.mapView addOverlay:overlay];
    
    UIImage *image = [UIImage imageNamed:@"groundOverlay"];
    QGroundOverlay *groundOverlay = [QGroundOverlay groundOverlayWithCoordinate:CLLocationCoordinate2DMake(40.040219,116.273348) zoomLevel:17 anchor:CGPointMake(0.5, 0.5) icon:image];

    [self.mapView addOverlay:groundOverlay];
}

- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay {
    if ([overlay isKindOfClass:[QGroundOverlay class]]) {
        _groundOverlayView = [[QGroundOverlayView alloc] initWithOverlay:overlay];
        _groundOverlayView.displayLevel = 0;
        return _groundOverlayView;
    }
    
    return nil;
}

@end
