//
//  AnnotationViewCustomCollisionMainViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2024/4/3.
//  Copyright © 2024 tencent. All rights reserved.
//

#import "AnnotationViewCustomCollisionMainViewController.h"

@interface AnnotationViewCustomCollisionMainViewController()

@property (nonatomic, strong) QPointAnnotation *anno;

@property (nonatomic, strong) QPointAnnotation *anno2;

@end

@implementation AnnotationViewCustomCollisionMainViewController

- (QAnnotationView *)mapView:(QMapView *)mapView viewForAnnotation:(id<QAnnotation>)annotation
{
	if ([annotation isKindOfClass:[QPointAnnotation class]])
	{
		static NSString *pointReuseIndetifier = @"pointReuseIndetifier";
		QAnnotationView *annotationView = (QAnnotationView*)[self.mapView dequeueReusableAnnotationViewWithIdentifier:pointReuseIndetifier];
		
		if (annotationView == nil)
		{
			annotationView = [[QAnnotationView alloc] initWithAnnotation:annotation reuseIdentifier:pointReuseIndetifier];
		}
		
		annotationView.canShowCallout   = YES;
		annotationView.zIndex = [annotation.title intValue];
		annotationView.collisionType = QAnnotationViewCollisionWithLabel | QAnnotationViewCollisionWithQAnnotationView;
		
		// 设置自定义主图碰撞区域
		[self setCustomMainView:annotationView];
		
		return annotationView;
	}
	
	return nil;
}


#pragma mark - Setup

- (void)setupAnnotations
{
	{
		self.anno = [[QPointAnnotation alloc] init];
		self.anno.coordinate = CLLocationCoordinate2DMake(39.8791, 116.3672);
		self.anno.title = @"100";
		
		[self.mapView addAnnotation:self.anno];
	}
	
	{
		self.anno2 = [[QPointAnnotation alloc] init];
		self.anno2.coordinate = CLLocationCoordinate2DMake(39.884318,116.461515);
		self.anno2.title = @"10";
		[self.mapView addAnnotation:self.anno2];
	}
}

- (void)viewDidLoad
{
	[super viewDidLoad];
	
	[self setupAnnotations];
}

#pragma mark -- CustomMainView

- (void)setCustomMainView:(QAnnotationView *)annoView
{
	
	if ([annoView.annotation.title isEqualToString:@"100"]) {
		
		UIImage *image = [UIImage imageNamed:@"good"];
		UIImageView *imgView = [[UIImageView alloc] initWithImage:image];
		
		[annoView addSubview:imgView];
		[annoView setQAnnotationViewCollisionMainView:imgView];
		
	}
	else {
		UIImage *image = [UIImage imageNamed:@"car"];
		UIImageView *imgView = [[UIImageView alloc] initWithImage:image];
		
		[annoView addSubview:imgView];
		[annoView setQAnnotationViewCollisionMainView:imgView];
	}
	
}

@end
