//
//  QAnnotatioViewDefines.h
//  QMapKit
//
//  Created by Keith Cao on 2023/11/29.
//  Copyright © 2023 tencent. All rights reserved.
//

#ifndef QAnnotatioViewDefines_h
#define QAnnotatioViewDefines_h

#import <UIKit/UIKit.h>

/**
 * @enum QAnnotationViewDragState
 *  QAnnotationView的拖拽状态
 */
typedef enum {
	QAnnotationViewDragStateNone = 0,      ///< 静止状态.
	QAnnotationViewDragStateStarting,      ///< 开始拖动
	QAnnotationViewDragStateDragging,      ///< 拖动中
	QAnnotationViewDragStateCanceling,     ///< 取消拖动
	QAnnotationViewDragStateEnding         ///< 拖动结束
} QAnnotationViewDragState;

/**
 * @brief QAnnotationViewCollisionType
 *  QAnnotationView的碰撞类型
 */
typedef NS_OPTIONS(NSUInteger,  QAnnotationViewCollisionType){
	QAnnotationViewCollisionTypeNone  = 0,					/// 不发生碰撞
	QAnnotationViewCollisionWithLabel = 1 << 0,				/// 可以与地图POI元素碰撞
	QAnnotationViewCollisionWithQAnnotationView = 1 << 1 	///可以和Marker碰撞
};

/**
 * @enum QAnnotationViewCollisionRelation
 *  QAnnotationView上元素的碰撞关系
 */
typedef NS_ENUM(NSInteger, QAnnotationViewCollisionRelation){
	QAnnotationViewCollisionRelationAlone = 0,		/// 碰撞关联关系，callout、子marker碰撞不影响QAnnotationView本身
	QAnnotationViewCollisionRelationTogether		/// 碰撞关联关系，callout、子marker碰撞会影响QAnnotationView本身，子Marker的碰撞类型跟随QAnnotationView
};

/**
 *	@brief QAnnotationView碰撞协议
 */
@protocol QAnnotationViewCollisionDelegate <NSObject>

@required

// 碰撞类型
@property (nonatomic, assign) QAnnotationViewCollisionType collisionType;

@end

#endif /* QAnnotatioViewDefines_h */
