//
//  BicyclingSearchViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2023/10/19.
//  Copyright © 2023 tencent. All rights reserved.
//

#import "BicyclingSearchViewController.h"
#import <QMapKit/QMSSearchKit.h>
#import "QSearchTools.h"

@interface BicyclingSearchViewController () <QMSSearchDelegate>

@property (nonatomic, strong) QMSSearcher *mySearcher;

@end

@implementation BicyclingSearchViewController

- (void)searchBicycleRoute
{
	QMSBicyclingRouteSearchOption *bicyclingSearchOption = [[QMSBicyclingRouteSearchOption alloc] init];
	[bicyclingSearchOption setFromCoordinate:CLLocationCoordinate2DMake(39.984042,116.307535)];
	[bicyclingSearchOption setToCoordinate:CLLocationCoordinate2DMake(39.980869,116.325238)];
	
	[self.mySearcher searchWithBicyclingRouteSearchOption:bicyclingSearchOption];
	
}

- (void)drawRouteLineWithResult:(QMSBicyclingRouteSearchResult *)result
{
	[self.mapView removeOverlays:self.mapView.overlays];
	
	QMSRoutePlan *routePlan = result.routes.firstObject;
	
	NSUInteger count = routePlan.polyline.count;
	CLLocationCoordinate2D coordinateArray[count];
	for (int i = 0; i < count; ++i)
	{
		coordinateArray[i] = [QSearchTools decodeCoordinateValue:[routePlan.polyline objectAtIndex:i]];
	}
	
	NSArray *routeStyles = [QSearchTools getSegmentStyleFromRouteStep:routePlan.steps];
	
	QPolyline *polyline = [[QPolyline alloc] initWithCoordinates:coordinateArray count:count];
	
	polyline.userData = routeStyles;
	
	[self.mapView addOverlay:polyline];
	QMapRect bound = polyline.boundingMapRect;
	[self.mapView setVisibleMapRect:bound edgePadding:UIEdgeInsetsMake(50, 30, 30, 50) animated:YES];
	
}

// 经纬度转换
- (QPolyline *)createPolylineWithResultPoints:(NSArray <NSValue *> *)points
{
	NSUInteger count = points.count;
	if (count <2) return nil;
	CLLocationCoordinate2D coordinateArray[count];
	for (int i = 0; i < count; ++i)
	{
		coordinateArray[i] = [QSearchTools decodeCoordinateValue:[points objectAtIndex:i]];
	}
	QPolyline *polyline = [[QPolyline alloc] initWithCoordinates:coordinateArray count:count];
	return polyline;
}

- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay
{
	if ([overlay isKindOfClass:[QPolyline class]])
	{
		QPolyline *polyline = (QPolyline*)overlay;
		QTexturePolylineView *polylineRender = [[QTexturePolylineView alloc] initWithPolyline:polyline];
		polylineRender.segmentStyle = polyline.userData;
		polylineRender.lineWidth = 10;
		return polylineRender;
	}
	return nil;
}

#pragma mark - SearchDelegate

- (void)searchWithSearchOption:(QMSSearchOption *)searchOption didFailWithError:(NSError *)error
{
	NSLog(@"error: %@", error);
}
- (void)searchWithBicyclingRouteSearchOption:(QMSBicyclingRouteSearchOption *)bicyclingRouteSearchOption didRecevieResult:(QMSBicyclingRouteSearchResult *)bicyclingRouteSearchResult
{
	[self drawRouteLineWithResult:bicyclingRouteSearchResult];
	
	NSLog(@"bicyleRoute result is: %@", bicyclingRouteSearchResult);
}

- (void)viewDidLoad {
	[super viewDidLoad];
	
	self.mySearcher = [[QMSSearcher alloc] initWithDelegate:self];
	
	[self searchBicycleRoute];
}

@end
