//
//  OverlayViewController.m
//  QMapKitDemoNew
//
//  Created by tabsong on 17/5/11.
//  Copyright © 2017年 Tencent. All rights reserved.
//

#import "ShowPolygonViewController.h"

@interface ShowPolygonViewController ()

@property (nonatomic, strong) QPolygonView *polygonView;

@end

@implementation ShowPolygonViewController

- (NSString *)testTitle {
	return @"更新样式";
}

- (void)handleTestAction
{
	/* Polygon. */
	CLLocationCoordinate2D coordinates[4];
	coordinates[0].latitude = 39.9542;
	coordinates[0].longitude = 116.514;
	
	coordinates[1].latitude = 39.9542;
	coordinates[1].longitude = 116.574;
	
	coordinates[2].latitude = 39.8742;
	coordinates[2].longitude = 116.574;
	
	coordinates[3].latitude = 39.8242;
	coordinates[3].longitude = 116.514;
	
	// 动态更新polyon的坐标
	[_polygonView updateOverlayPoints:coordinates pointCount:4];
	
	// 动态更新polygon样式
	_polygonView.lineWidth = _polygonView.lineWidth + 1;
	_polygonView.strokeColor = [UIColor redColor];
	_polygonView.fillColor = [[UIColor greenColor] colorWithAlphaComponent:0.2];
	
}

- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay
{
	if ([overlay isKindOfClass:[QPolygon class]])
	{
		_polygonView = [[QPolygonView alloc] initWithPolygon:overlay];
		_polygonView.lineWidth   = 3;
		_polygonView.strokeColor = [UIColor colorWithRed:.2 green:.3 blue:.4 alpha:.8];
		_polygonView.fillColor   = [[UIColor blueColor] colorWithAlphaComponent:0.2];
		
		return _polygonView;
	}
	return nil;
}

- (void)setupOverlays
{
	/* Polygon. */
	CLLocationCoordinate2D coordinates[3];
	coordinates[0].latitude = 39.9442;
	coordinates[0].longitude = 116.514;
	
	coordinates[1].latitude = 39.9442;
	coordinates[1].longitude = 116.574;
	
	coordinates[2].latitude = 39.8642;
	coordinates[2].longitude = 116.574;
	
	QPolygon *polygon = [QPolygon polygonWithCoordinates:coordinates count:3];
	
	[self.mapView addOverlay:polygon];
}

- (void)viewDidLoad
{
	[super viewDidLoad];
	
	[self setupOverlays];
	
	self.mapView.centerCoordinate = CLLocationCoordinate2DMake(39.869675,116.553444);
}

@end
