//
//  GroudOverlayViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2023/10/17.
//  Copyright © 2023 tencent. All rights reserved.
//

#import "GroundOverlayViewController.h"

@interface GroundOverlayViewController ()
@property (strong) QGroundOverlay *overlay;
@property (strong) QGroundOverlay *overlay2;
@end

@implementation GroundOverlayViewController

- (void)viewDidLoad {
	[super viewDidLoad];
	// Do any additional setup after loading the view.
	
	self.mapView.zoomLevel = 15;
	
	QGroundOverlay *overlay = [self constructOverlay1];
	self.overlay = overlay;
	[self.mapView addOverlay:overlay];
	[self.mapView setVisibleMapRect:overlay.boundingMapRect edgePadding:UIEdgeInsetsMake(30, 40, 30, 40) animated:YES];
}

- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay
{
	if ([overlay isKindOfClass:[QGroundOverlay class]])
	{
		QGroundOverlayView *view = [[QGroundOverlayView alloc] initWithOverlay:overlay];
		view.zIndex = 3;
		view.displayLevel = QOverlayLevelAboveBuildings;
		return view;
	}
	return nil;
}

- (QGroundOverlay *)constructOverlay1 {
	QCoordinateBounds bounds = {CLLocationCoordinate2DMake(self.mapView.centerCoordinate.latitude+0.013, self.mapView.centerCoordinate.longitude+.051), CLLocationCoordinate2DMake(self.mapView.centerCoordinate.latitude-0.003, self.mapView.centerCoordinate.longitude-.011)};
	QMapRect rect = QMapRectForCoordinateBounds(bounds);
	bounds = QCoordinateBoundsForMapRect(rect);
	UIImage *icon = [UIImage imageNamed:@"foot.jpg"];
	QGroundOverlay *ground = [QGroundOverlay groundOverlayWithCoordinate:bounds.southWest zoomLevel:15 anchor:CGPointMake(0.0, 0.5) icon:icon];
	ground.opacity = 1.0;
	
	return ground;
}

@end
