//
//  CustomLayerViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2019/12/17.
//  Copyright © 2019 tencent. All rights reserved.
//

#import "CustomLayerViewController.h"

@interface CustomLayerViewController ()

@property BOOL hasAdded;

@property (nonatomic, strong) QCustomLayer *customLayer;

@end

@implementation CustomLayerViewController

- (void)handleTestAction
{
    if (!_hasAdded) {
        
        // 移除个性化图层
        [self.mapView addCustomLayer:_customLayer];
        _hasAdded = YES;
    }
    else
    {
        [self.mapView removeCustomLayer:_customLayer];
        _hasAdded = NO;
    }
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.mapView.zoomLevel = 15;
    
    // 将地图中心点移动到图层所在区域
//    self.mapView.centerCoordinate = CLLocationCoordinate2DMake(39.933960,116.405640);
    
    
    // 初始化和在地图上添加个性化图层
    self.customLayer = [[QCustomLayer alloc] init];
    // 个性化图层的ID, 个性化图层配置指南：https://lbs.qq.com/mobile/iOSMapSDK/mapGuide/overlayCustomLayer
    _customLayer.layerID = @"您的个性化图层ID";
    [self.mapView addCustomLayer:_customLayer];
    self.hasAdded = YES;
}


@end
