//
//  ShowRelatedAnnotationViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2019/7/17.
//  Copyright © 2019 tencent. All rights reserved.
//

#import "ShowRelatedAnnotationViewController.h"

@interface ShowRelatedAnnotationViewController ()

@property (nonatomic, strong) NSMutableArray <id<QAnnotation>> *annotations;

@property (nonatomic, strong) NSMutableArray<id <QOverlay>> *overlays;

@property (nonatomic) QMapRect annotationRect;

@end

@implementation ShowRelatedAnnotationViewController

- (NSString *)testTitle
{
    return @"展示标记点";
}

- (void)handleTestAction
{
    
    //缩放地图展示相关联的标记点
    QMapRect maprect = [self.mapView mapRectThatFits:_annotationRect containsCalloutView:YES annotations:self.annotations edgePadding:UIEdgeInsetsZero];
    [self.mapView setVisibleMapRect:maprect animated:YES];
}

- (QAnnotationView *)mapView:(QMapView *)mapView viewForAnnotation:(id<QAnnotation>)annotation
{
    
    if ([annotation isKindOfClass:[QPointAnnotation class]]) {
        
        static NSString *pointReuseIndetifier = @"pointReuseIndetifier";
        QAnnotationView *annotationView = (QAnnotationView *)[self.mapView dequeueReusableAnnotationViewWithIdentifier:pointReuseIndetifier];
        
        if (annotationView == nil)
            {
            annotationView = [[QAnnotationView alloc] initWithAnnotation:annotation reuseIdentifier:pointReuseIndetifier];
            }
        
        annotationView.canShowCallout   = YES;
        
        UIImage *img = [UIImage imageNamed:@"marker"];
		
		annotationView.centerOffset = CGPointMake(0, -img.size.height / 2.0);
        
        annotationView.image = img;
        
        return annotationView;
    }
    
    return  nil;
    
}

- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay
{
    if ([overlay isKindOfClass:[QPolygon class]]) {
        QPolygonView *polygonRender = [[QPolygonView alloc] initWithPolygon:overlay];
        polygonRender.lineWidth   = 2;
        polygonRender.strokeColor = [UIColor colorWithRed:.2 green:.1 blue:.1 alpha:.8];
        polygonRender.fillColor   = [[UIColor blueColor] colorWithAlphaComponent:0.2];
        
        return  polygonRender;
    }
    
    return nil;
}


//创建标记点
-(void)setupAnnotations
{
    self.annotations = [NSMutableArray array];
    self.overlays = [NSMutableArray array];
	
	CLLocationCoordinate2D coors[] = {  {39.911237, 116.375139},
		{39.91143, 116.375572},
		{39.913233, 116.374349},
		{39.911316, 116.372914}
		};
	
	int size = sizeof(coors) / sizeof(CLLocationCoordinate2D);
	
	for (int i = 0; i < size; i++)
	{
		QPointAnnotation *annotation = [[QPointAnnotation alloc] init];
		annotation.title = [NSString stringWithFormat:@"%d", i];
		annotation.coordinate = coors[i];
		
		[self.annotations addObject:annotation];
	}
    
    [self.mapView addAnnotations:self.annotations];
    
    QPolygon *polygon = [QPolygon polygonWithCoordinates:coors count:size];
    [self.overlays addObject: polygon];
    [self.mapView addOverlays:self.overlays];
	
	_annotationRect = polygon.boundingMapRect;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupAnnotations];
    self.mapView.zoomLevel = 18;
    [self.mapView setCenterCoordinate:CLLocationCoordinate2DMake(39.911484,116.374327)];
}

@end
